/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.research;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.platform.Services;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class IconDefinition {
    public static final Codec<IconDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("isItem", (Object)false).forGetter(IconDefinition::isItem), (App)Codec.BOOL.optionalFieldOf("isTag", (Object)false).forGetter(IconDefinition::isTag), (App)ResourceLocation.CODEC.fieldOf("location").forGetter(IconDefinition::getLocation), (App)Codec.STRING.optionalFieldOf("tooltipOverride").forGetter(def -> def.tooltipOverrideOpt)).apply((Applicative)instance, IconDefinition::new));
    public static final StreamCodec<ByteBuf, IconDefinition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, IconDefinition::isItem, (StreamCodec)ByteBufCodecs.BOOL, IconDefinition::isTag, (StreamCodec)ResourceLocation.STREAM_CODEC, IconDefinition::getLocation, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), def -> def.tooltipOverrideOpt, IconDefinition::new);
    private final boolean isItem;
    private final boolean isTag;
    private final ResourceLocation location;
    private final Optional<String> tooltipOverrideOpt;

    private IconDefinition(boolean isItem, boolean isTag, ResourceLocation loc, Optional<String> tooltipOverrideOpt) {
        this.isItem = isItem;
        this.isTag = isTag;
        this.location = loc;
        this.tooltipOverrideOpt = tooltipOverrideOpt;
    }

    public static IconDefinition of(ItemLike item) {
        return new IconDefinition(true, false, Services.ITEMS_REGISTRY.getKey(item.asItem()), Optional.empty());
    }

    public static IconDefinition of(TagKey<Item> tagKey) {
        return new IconDefinition(false, true, tagKey.location(), Optional.empty());
    }

    public static IconDefinition of(ResourceLocation loc) {
        return IconDefinition.of(loc, null);
    }

    public static IconDefinition of(ResourceLocation loc, String tooltipKey) {
        return new IconDefinition(false, false, (ResourceLocation)Preconditions.checkNotNull((Object)loc), Optional.ofNullable(tooltipKey));
    }

    public boolean isItem() {
        return this.isItem;
    }

    public boolean isTag() {
        return this.isTag;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    @Nullable
    public Item asItem() {
        return this.isItem ? (Item)Services.ITEMS_REGISTRY.get(this.location) : null;
    }

    @Nullable
    public TagKey<Item> asTagKey() {
        return this.isTag ? TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)this.location) : null;
    }

    public List<Component> getTooltipLines() {
        if (this.tooltipOverrideOpt.isPresent()) {
            return ImmutableList.of((Object)Component.translatable((String)this.tooltipOverrideOpt.get()));
        }
        if (this.isItem) {
            return ImmutableList.of((Object)this.asItem().getDescription());
        }
        if (this.isTag) {
            return Services.ITEMS_REGISTRY.getTag(this.asTagKey()).stream().map(Item::getDescription).toList();
        }
        return ImmutableList.of();
    }
}

