/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.theorycrafting;

import com.verdantartifice.primalmagick.common.menus.ResearchTableMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftManager;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import commonnetwork.networking.data.PacketContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CompleteProjectPacket
implements IMessageToServer {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("complete_project");
    public static final StreamCodec<RegistryFriendlyByteBuf, CompleteProjectPacket> STREAM_CODEC = StreamCodec.ofMember(CompleteProjectPacket::encode, CompleteProjectPacket::decode);
    protected final int windowId;

    public CompleteProjectPacket(int windowId) {
        this.windowId = windowId;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(CompleteProjectPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(message.windowId);
    }

    public static CompleteProjectPacket decode(RegistryFriendlyByteBuf buf) {
        return new CompleteProjectPacket(buf.readVarInt());
    }

    public static void onMessage(PacketContext<CompleteProjectPacket> ctx) {
        CompleteProjectPacket message = (CompleteProjectPacket)ctx.message();
        ServerPlayer player = ctx.sender();
        Services.CAPABILITIES.knowledge((Player)player).ifPresent(knowledge -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof ResearchTableMenu) {
                ResearchTableMenu researchMenu = (ResearchTableMenu)patt0$temp;
                if (researchMenu.containerId == message.windowId) {
                    researchMenu.consumeWritingImplements();
                    researchMenu.getContainerLevelAccess().execute((world, blockPos) -> {
                        Project project = knowledge.getActiveResearchProject();
                        RandomSource rand = player.getRandom();
                        if (project != null && project.isSatisfied((Player)player, TheorycraftManager.getSurroundings(world, blockPos)) && project.consumeSelectedMaterials((Player)player)) {
                            if (rand.nextDouble() < project.getSuccessChance()) {
                                ResearchManager.addKnowledge((Player)player, KnowledgeType.THEORY, project.getTheoryPointReward());
                                project.otherRewards().forEach(reward -> reward.grant(player));
                                StatsManager.incrementValue((Player)player, StatsPM.RESEARCH_PROJECTS_COMPLETED);
                                PacketHandler.sendToPlayer(new PlayClientSoundPacket(SoundsPM.WRITING.get(), 1.0f, 1.0f + (float)rand.nextGaussian() * 0.05f), player);
                            } else {
                                PacketHandler.sendToPlayer(new PlayClientSoundPacket(SoundEvents.GLASS_BREAK, 1.0f, 1.0f + (float)rand.nextGaussian() * 0.05f), player);
                            }
                        }
                        knowledge.setActiveResearchProject(TheorycraftManager.createRandomProject(player, blockPos));
                    });
                    knowledge.sync(player);
                }
            }
        });
    }
}

