/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.spellcrafting;

import com.verdantartifice.primalmagick.common.menus.SpellcraftingAltarMenu;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.spells.SpellComponent;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SetSpellComponentPropertyPacket
implements IMessageToServer {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("set_spell_component_property");
    public static final StreamCodec<RegistryFriendlyByteBuf, SetSpellComponentPropertyPacket> STREAM_CODEC = StreamCodec.ofMember(SetSpellComponentPropertyPacket::encode, SetSpellComponentPropertyPacket::decode);
    protected final int windowId;
    protected final SpellComponent attr;
    protected final SpellProperty property;
    protected final int value;

    public SetSpellComponentPropertyPacket(int windowId, SpellComponent attr, SpellProperty property, int value) {
        this.windowId = windowId;
        this.attr = attr;
        this.property = property;
        this.value = value;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(SetSpellComponentPropertyPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(message.windowId);
        buf.writeEnum((Enum)message.attr);
        SpellProperty.STREAM_CODEC.encode((Object)buf, (Object)message.property);
        buf.writeVarInt(message.value);
    }

    public static SetSpellComponentPropertyPacket decode(RegistryFriendlyByteBuf buf) {
        return new SetSpellComponentPropertyPacket(buf.readVarInt(), (SpellComponent)buf.readEnum(SpellComponent.class), (SpellProperty)SpellProperty.STREAM_CODEC.decode((Object)buf), buf.readVarInt());
    }

    public static void onMessage(PacketContext<SetSpellComponentPropertyPacket> ctx) {
        SetSpellComponentPropertyPacket message = (SetSpellComponentPropertyPacket)ctx.message();
        ServerPlayer player = ctx.sender();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof SpellcraftingAltarMenu) {
            SpellcraftingAltarMenu altarMenu = (SpellcraftingAltarMenu)abstractContainerMenu;
            if (altarMenu.containerId == message.windowId) {
                altarMenu.setSpellPropertyValue(message.attr, message.property, message.value);
            }
        }
    }
}

