/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.scribe_table;

import com.verdantartifice.primalmagick.common.menus.ScribeTranscribeWorksMenu;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TranscribeActionPacket
implements IMessageToServer {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("transcribe_action");
    public static final StreamCodec<RegistryFriendlyByteBuf, TranscribeActionPacket> STREAM_CODEC = StreamCodec.ofMember(TranscribeActionPacket::encode, TranscribeActionPacket::decode);
    protected final int windowId;

    public TranscribeActionPacket(int windowId) {
        this.windowId = windowId;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(TranscribeActionPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(message.windowId);
    }

    public static TranscribeActionPacket decode(RegistryFriendlyByteBuf buf) {
        return new TranscribeActionPacket(buf.readVarInt());
    }

    public static void onMessage(PacketContext<TranscribeActionPacket> ctx) {
        TranscribeActionPacket message = (TranscribeActionPacket)ctx.message();
        ServerPlayer player = ctx.sender();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ScribeTranscribeWorksMenu) {
            ScribeTranscribeWorksMenu menu = (ScribeTranscribeWorksMenu)abstractContainerMenu;
            if (player.containerMenu.containerId == message.windowId) {
                menu.doTranscribe();
            }
        }
    }
}

