/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.scribe_table;

import com.verdantartifice.primalmagick.common.menus.ScribeStudyVocabularyMenu;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class StudyVocabularyActionPacket
implements IMessageToServer {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("study_vocabulary_action");
    public static final StreamCodec<RegistryFriendlyByteBuf, StudyVocabularyActionPacket> STREAM_CODEC = StreamCodec.ofMember(StudyVocabularyActionPacket::encode, StudyVocabularyActionPacket::decode);
    protected final int windowId;
    protected final int slotId;

    public StudyVocabularyActionPacket(int windowId, int slotId) {
        this.windowId = windowId;
        this.slotId = slotId;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(StudyVocabularyActionPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(message.windowId);
        buf.writeVarInt(message.slotId);
    }

    public static StudyVocabularyActionPacket decode(RegistryFriendlyByteBuf buf) {
        return new StudyVocabularyActionPacket(buf.readVarInt(), buf.readVarInt());
    }

    public static void onMessage(PacketContext<StudyVocabularyActionPacket> ctx) {
        StudyVocabularyActionPacket message = (StudyVocabularyActionPacket)ctx.message();
        ServerPlayer player = ctx.sender();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ScribeStudyVocabularyMenu) {
            ScribeStudyVocabularyMenu menu = (ScribeStudyVocabularyMenu)abstractContainerMenu;
            if (menu.containerId == message.windowId) {
                menu.doStudyClick((Player)player, message.slotId);
            }
        }
    }
}

