/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tiles.devices.EssenceCaskTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WithdrawCaskEssencePacket
implements IMessageToServer {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("withdraw_cask_essence");
    public static final StreamCodec<RegistryFriendlyByteBuf, WithdrawCaskEssencePacket> STREAM_CODEC = StreamCodec.ofMember(WithdrawCaskEssencePacket::encode, WithdrawCaskEssencePacket::decode);
    protected final EssenceType essenceType;
    protected final Source essenceSource;
    protected final int amount;
    protected final BlockPos caskPos;

    public WithdrawCaskEssencePacket(EssenceType type, Source source, int amount, BlockPos pos) {
        this.essenceType = type;
        this.essenceSource = source;
        this.amount = amount;
        this.caskPos = pos;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(WithdrawCaskEssencePacket message, RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)message.essenceType);
        Source.STREAM_CODEC.encode((Object)buf, (Object)message.essenceSource);
        buf.writeVarInt(message.amount);
        buf.writeBlockPos(message.caskPos);
    }

    public static WithdrawCaskEssencePacket decode(RegistryFriendlyByteBuf buf) {
        return new WithdrawCaskEssencePacket((EssenceType)buf.readEnum(EssenceType.class), (Source)Source.STREAM_CODEC.decode((Object)buf), buf.readVarInt(), buf.readBlockPos());
    }

    public static void onMessage(PacketContext<WithdrawCaskEssencePacket> ctx) {
        EssenceCaskTileEntity caskTile;
        int curCount;
        int toRemove;
        BlockEntity tile;
        WithdrawCaskEssencePacket message = (WithdrawCaskEssencePacket)ctx.message();
        ServerPlayer player = ctx.sender();
        Level level = player.getCommandSenderWorld();
        if (message.caskPos != null && level.isLoaded(message.caskPos) && (tile = level.getBlockEntity(message.caskPos)) instanceof EssenceCaskTileEntity && (toRemove = Math.min(message.amount, curCount = (caskTile = (EssenceCaskTileEntity)tile).getEssenceCount(message.essenceType, message.essenceSource))) > 0) {
            int newCount = Math.max(0, curCount - toRemove);
            caskTile.setEssenceCount(message.essenceType, message.essenceSource, newCount);
            ItemStack stack = EssenceItem.getEssence(message.essenceType, message.essenceSource, toRemove);
            if (!player.getInventory().add(stack)) {
                player.drop(stack, false);
            }
        }
    }
}

