/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SetActiveSpellPacket
implements IMessageToServer {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("set_active_spell");
    public static final StreamCodec<RegistryFriendlyByteBuf, SetActiveSpellPacket> STREAM_CODEC = StreamCodec.ofMember(SetActiveSpellPacket::encode, SetActiveSpellPacket::decode);
    protected final int index;

    public SetActiveSpellPacket(int index) {
        this.index = index;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(SetActiveSpellPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(message.index);
    }

    public static SetActiveSpellPacket decode(RegistryFriendlyByteBuf buf) {
        return new SetActiveSpellPacket(buf.readVarInt());
    }

    public static void onMessage(PacketContext<SetActiveSpellPacket> ctx) {
        SetActiveSpellPacket message = (SetActiveSpellPacket)ctx.message();
        ServerPlayer player = ctx.sender();
        if (player != null) {
            SpellManager.setActiveSpellIndex((Player)player, player.getMainHandItem(), player.getOffhandItem(), message.index);
        }
    }
}

