/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.tiles.base.IHasCustomScanContents;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import commonnetwork.networking.data.PacketContext;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScanPositionPacket
implements IMessageToServer {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("scan_position");
    public static final StreamCodec<RegistryFriendlyByteBuf, ScanPositionPacket> STREAM_CODEC = StreamCodec.ofMember(ScanPositionPacket::encode, ScanPositionPacket::decode);
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final BlockPos pos;
    protected final ItemStack toolStack;

    public ScanPositionPacket(@Nonnull BlockPos pos, @Nonnull ItemStack toolStack) {
        this.pos = pos;
        this.toolStack = toolStack;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(ScanPositionPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(message.pos);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)message.toolStack);
    }

    public static ScanPositionPacket decode(RegistryFriendlyByteBuf buf) {
        return new ScanPositionPacket(buf.readBlockPos(), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
    }

    public static void onMessage(PacketContext<ScanPositionPacket> ctx) {
        ScanPositionPacket message = (ScanPositionPacket)ctx.message();
        ServerPlayer player = ctx.sender();
        Level world = player.getCommandSenderWorld();
        if (message.pos != null && world.isLoaded(message.pos)) {
            Services.CAPABILITIES.knowledge((Player)player).ifPresent(knowledge -> {
                ArrayList<CompletionStage> foundFutures = new ArrayList<CompletionStage>();
                ItemStack posStack = new ItemStack((ItemLike)world.getBlockState(message.pos).getBlock());
                foundFutures.add(CompletableFuture.completedFuture(posStack).thenCombine(ResearchManager.isScannedAsync(posStack, (Player)player), (stack, isScanned) -> isScanned == false && ResearchManager.setScanned(stack, player, false)));
                Services.CAPABILITIES.itemHandler(world, message.pos, Direction.UP).ifPresent(handler -> {
                    int scanCount = 0;
                    for (int slot = 0; slot < handler.getSlots(); ++slot) {
                        ItemStack chestStack = handler.getStackInSlot(slot);
                        if (chestStack == null || chestStack.isEmpty()) continue;
                        if (scanCount >= 108) {
                            player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.scan.toobig").withStyle(ChatFormatting.RED), true);
                            break;
                        }
                        foundFutures.add(CompletableFuture.completedFuture(chestStack).thenCombine(ResearchManager.isScannedAsync(chestStack, (Player)player), (stack, isScanned) -> isScanned == false && ResearchManager.setScanned(stack, player, false)));
                        ++scanCount;
                    }
                });
                BlockEntity patt0$temp = world.getBlockEntity(message.pos);
                if (patt0$temp instanceof IHasCustomScanContents) {
                    IHasCustomScanContents customScanContents = (IHasCustomScanContents)patt0$temp;
                    customScanContents.getCustomScanContents().forEach(customStack -> foundFutures.add(CompletableFuture.completedFuture(customStack).thenCombine(ResearchManager.isScannedAsync(customStack, (Player)player), (stack, isScanned) -> isScanned == false && ResearchManager.setScanned(stack, player, false))));
                }
                ((CompletableFuture)Util.sequence(foundFutures).thenAccept(foundList -> {
                    if (foundList.stream().mapToInt(found -> found != false ? 1 : 0).sum() > 0) {
                        player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.scan.success").withStyle(ChatFormatting.GREEN), true);
                        knowledge.sync(player);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.scan.repeat").withStyle(ChatFormatting.RED), true);
                    }
                })).exceptionally(e -> {
                    LOGGER.error("Failed to scan block at position " + String.valueOf(message.pos), e);
                    return null;
                });
                CriteriaTriggersPM.SCAN_LOCATION.get().trigger(player, message.pos, message.toolStack);
            });
        }
    }
}

