/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.misc;

import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScanItemPacket
implements IMessageToServer {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("scan_item");
    public static final StreamCodec<RegistryFriendlyByteBuf, ScanItemPacket> STREAM_CODEC = StreamCodec.ofMember(ScanItemPacket::encode, ScanItemPacket::decode);
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final ItemStack stack;

    public ScanItemPacket(ItemStack stack) {
        this.stack = stack;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(ScanItemPacket message, RegistryFriendlyByteBuf buf) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)message.stack);
    }

    public static ScanItemPacket decode(RegistryFriendlyByteBuf buf) {
        return new ScanItemPacket((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
    }

    public static void onMessage(PacketContext<ScanItemPacket> ctx) {
        ScanItemPacket message = (ScanItemPacket)ctx.message();
        if (message.stack != null && !message.stack.isEmpty()) {
            ServerPlayer player = ctx.sender();
            ((CompletableFuture)ResearchManager.isScannedAsync(message.stack, (Player)player).thenAccept(isScanned -> {
                if (isScanned.booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.scan.repeat").withStyle(ChatFormatting.RED), true);
                } else if (ResearchManager.setScanned(message.stack, player)) {
                    player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.scan.success").withStyle(ChatFormatting.GREEN), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.scan.fail").withStyle(ChatFormatting.RED), true);
                }
            })).exceptionally(e -> {
                LOGGER.error("Failed to scan item stack " + message.stack.toString(), e);
                return null;
            });
        }
    }
}

