/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class WandPoofPacket
implements IMessageToClient {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("wand_poof");
    public static final StreamCodec<RegistryFriendlyByteBuf, WandPoofPacket> STREAM_CODEC = StreamCodec.ofMember(WandPoofPacket::encode, WandPoofPacket::decode);
    protected final double x;
    protected final double y;
    protected final double z;
    protected final int color;
    protected final boolean sound;
    protected final Direction face;

    public WandPoofPacket(double x, double y, double z, int color, boolean sound, @Nonnull Direction facing) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
        this.sound = sound;
        this.face = facing;
    }

    public WandPoofPacket(@Nonnull BlockPos pos, int color, boolean sound, @Nonnull Direction facing) {
        this((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, color, sound, facing);
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(WandPoofPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeDouble(message.x);
        buf.writeDouble(message.y);
        buf.writeDouble(message.z);
        buf.writeVarInt(message.color);
        buf.writeBoolean(message.sound);
        buf.writeEnum((Enum)message.face);
    }

    public static WandPoofPacket decode(RegistryFriendlyByteBuf buf) {
        return new WandPoofPacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readVarInt(), buf.readBoolean(), (Direction)buf.readEnum(Direction.class));
    }

    public static void onMessage(PacketContext<WandPoofPacket> ctx) {
        WandPoofPacket message = (WandPoofPacket)ctx.message();
        FxDispatcher.INSTANCE.wandPoof(message.x, message.y, message.z, message.color, message.sound, message.face);
    }
}

