/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.fx;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class RemovePropMarkerPacket
implements IMessageToClient {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("remove_prop_marker");
    public static final StreamCodec<RegistryFriendlyByteBuf, RemovePropMarkerPacket> STREAM_CODEC = StreamCodec.ofMember(RemovePropMarkerPacket::encode, RemovePropMarkerPacket::decode);
    protected final BlockPos pos;

    public RemovePropMarkerPacket(@Nonnull BlockPos pos) {
        this.pos = pos;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(RemovePropMarkerPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(message.pos);
    }

    public static RemovePropMarkerPacket decode(RegistryFriendlyByteBuf buf) {
        return new RemovePropMarkerPacket(buf.readBlockPos());
    }

    public static void onMessage(PacketContext<RemovePropMarkerPacket> ctx) {
        Level world;
        RemovePropMarkerPacket message = (RemovePropMarkerPacket)ctx.message();
        Object object = world = Side.CLIENT.equals((Object)ctx.side()) ? ClientUtils.getCurrentLevel() : null;
        if (world != null && world.hasChunkAt(message.pos)) {
            FxDispatcher.INSTANCE.removePropMarker(message.pos);
        }
    }
}

