/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileToClientPacket
implements IMessageToClient {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("tile_to_client");
    public static final StreamCodec<RegistryFriendlyByteBuf, TileToClientPacket> STREAM_CODEC = StreamCodec.ofMember(TileToClientPacket::encode, TileToClientPacket::decode);
    protected final BlockPos pos;
    protected final CompoundTag data;

    public TileToClientPacket(BlockPos pos, CompoundTag data) {
        this.pos = pos;
        this.data = data;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(TileToClientPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(message.pos);
        buf.writeNbt((Tag)message.data);
    }

    public static TileToClientPacket decode(RegistryFriendlyByteBuf buf) {
        return new TileToClientPacket(buf.readBlockPos(), buf.readNbt());
    }

    public static void onMessage(PacketContext<TileToClientPacket> ctx) {
        BlockEntity blockEntity;
        Level world;
        TileToClientPacket message = (TileToClientPacket)ctx.message();
        Object object = world = Side.CLIENT.equals((Object)ctx.side()) ? ClientUtils.getCurrentLevel() : null;
        if (world != null && world.hasChunkAt(message.pos) && (blockEntity = world.getBlockEntity(message.pos)) instanceof AbstractTilePM) {
            AbstractTilePM tile = (AbstractTilePM)blockEntity;
            tile.onMessageFromServer(message.data == null ? new CompoundTag() : message.data);
        }
    }
}

