/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncLinguisticsPacket
implements IMessageToClient {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("sync_linguistics");
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncLinguisticsPacket> STREAM_CODEC = StreamCodec.ofMember(SyncLinguisticsPacket::encode, SyncLinguisticsPacket::decode);
    protected final CompoundTag data;

    public SyncLinguisticsPacket(Player player) {
        this.data = Services.CAPABILITIES.linguistics(player).map(l -> (CompoundTag)l.serializeNBT((HolderLookup.Provider)player.registryAccess())).orElse(null);
    }

    protected SyncLinguisticsPacket(CompoundTag data) {
        this.data = data;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(SyncLinguisticsPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)message.data);
    }

    public static SyncLinguisticsPacket decode(RegistryFriendlyByteBuf buf) {
        return new SyncLinguisticsPacket(buf.readNbt());
    }

    public static void onMessage(PacketContext<SyncLinguisticsPacket> ctx) {
        Player player;
        Object object = player = Side.CLIENT.equals((Object)ctx.side()) ? ClientUtils.getCurrentPlayer() : null;
        if (player != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(l -> l.deserializeNBT((HolderLookup.Provider)player.registryAccess(), ((SyncLinguisticsPacket)ctx.message()).data));
        }
    }
}

