/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncCooldownsPacket
implements IMessageToClient {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("sync_cooldowns");
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCooldownsPacket> STREAM_CODEC = StreamCodec.ofMember(SyncCooldownsPacket::encode, SyncCooldownsPacket::decode);
    protected final CompoundTag data;

    public SyncCooldownsPacket(Player player) {
        this.data = Services.CAPABILITIES.cooldowns(player).map(c -> (CompoundTag)c.serializeNBT((HolderLookup.Provider)player.registryAccess())).orElse(null);
    }

    protected SyncCooldownsPacket(CompoundTag data) {
        this.data = data;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(SyncCooldownsPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)message.data);
    }

    public static SyncCooldownsPacket decode(RegistryFriendlyByteBuf buf) {
        return new SyncCooldownsPacket(buf.readNbt());
    }

    public static void onMessage(PacketContext<SyncCooldownsPacket> ctx) {
        Player player;
        Object object = player = Side.CLIENT.equals((Object)ctx.side()) ? ClientUtils.getCurrentPlayer() : null;
        if (player != null) {
            Services.CAPABILITIES.cooldowns(player).ifPresent(c -> c.deserializeNBT((HolderLookup.Provider)player.registryAccess(), ((SyncCooldownsPacket)ctx.message()).data));
        }
    }
}

