/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncCompanionsPacket
implements IMessageToClient {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("sync_companions");
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCompanionsPacket> STREAM_CODEC = StreamCodec.ofMember(SyncCompanionsPacket::encode, SyncCompanionsPacket::decode);
    protected final CompoundTag data;

    public SyncCompanionsPacket(Player player) {
        this.data = Services.CAPABILITIES.companions(player).map(c -> (CompoundTag)c.serializeNBT((HolderLookup.Provider)player.registryAccess())).orElse(null);
    }

    protected SyncCompanionsPacket(CompoundTag data) {
        this.data = data;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(SyncCompanionsPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)message.data);
    }

    public static SyncCompanionsPacket decode(RegistryFriendlyByteBuf buf) {
        return new SyncCompanionsPacket(buf.readNbt());
    }

    public static void onMessage(PacketContext<SyncCompanionsPacket> ctx) {
        Player player;
        Object object = player = Side.CLIENT.equals((Object)ctx.side()) ? ClientUtils.getCurrentPlayer() : null;
        if (player != null) {
            Services.CAPABILITIES.companions(player).ifPresent(companions -> companions.deserializeNBT((HolderLookup.Provider)player.registryAccess(), ((SyncCompanionsPacket)ctx.message()).data));
        }
    }
}

