/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.recipe_book.ArcaneSearchRegistry;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncArcaneRecipeBookPacket
implements IMessageToClient {
    public static final ResourceLocation CHANNEL = ResourceUtils.loc("sync_arcane_recipe_book");
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncArcaneRecipeBookPacket> STREAM_CODEC = StreamCodec.ofMember(SyncArcaneRecipeBookPacket::encode, SyncArcaneRecipeBookPacket::decode);
    protected final CompoundTag data;

    public SyncArcaneRecipeBookPacket(Player player) {
        this.data = Services.CAPABILITIES.arcaneRecipeBook(player).map(book -> book.serializeNBT((HolderLookup.Provider)player.registryAccess())).orElse(null);
    }

    protected SyncArcaneRecipeBookPacket(CompoundTag data) {
        this.data = data;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public static void encode(SyncArcaneRecipeBookPacket message, RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)message.data);
    }

    public static SyncArcaneRecipeBookPacket decode(RegistryFriendlyByteBuf buf) {
        return new SyncArcaneRecipeBookPacket(buf.readNbt());
    }

    public static void onMessage(PacketContext<SyncArcaneRecipeBookPacket> ctx) {
        Player player;
        SyncArcaneRecipeBookPacket message = (SyncArcaneRecipeBookPacket)ctx.message();
        Object object = player = Side.CLIENT.equals((Object)ctx.side()) ? ClientUtils.getCurrentPlayer() : null;
        if (player != null) {
            Services.CAPABILITIES.arcaneRecipeBook(player).ifPresent(recipeBook -> recipeBook.deserializeNBT((HolderLookup.Provider)player.registryAccess(), message.data, player.level().getRecipeManager()));
            ArcaneSearchRegistry.populate();
        }
    }
}

