/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.config;

import com.verdantartifice.primalmagick.common.books.grids.GridDefinition;
import com.verdantartifice.primalmagick.common.books.grids.GridDefinitionLoader;
import com.verdantartifice.primalmagick.common.network.packets.config.AcknowledgeLinguisticsGridConfigPacketNeoforge;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateLinguisticsGridConfigPacketNeoforge
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<UpdateLinguisticsGridConfigPacketNeoforge> TYPE = new CustomPacketPayload.Type(ResourceUtils.loc("update_linguistics_grid_neoforge"));
    public static final StreamCodec<FriendlyByteBuf, UpdateLinguisticsGridConfigPacketNeoforge> STREAM_CODEC = StreamCodec.ofMember(UpdateLinguisticsGridConfigPacketNeoforge::encode, UpdateLinguisticsGridConfigPacketNeoforge::decode);
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Map<ResourceLocation, GridDefinition> gridDefs;

    public UpdateLinguisticsGridConfigPacketNeoforge(Map<ResourceLocation, GridDefinition> gridDefs) {
        this.gridDefs = new HashMap<ResourceLocation, GridDefinition>(gridDefs);
    }

    protected UpdateLinguisticsGridConfigPacketNeoforge(FriendlyByteBuf buf) {
        this.gridDefs = new HashMap<ResourceLocation, GridDefinition>();
        int mapSize = buf.readVarInt();
        for (int index = 0; index < mapSize; ++index) {
            ResourceLocation loc = buf.readResourceLocation();
            GridDefinition gridDef = (GridDefinition)GridDefinition.streamCodec().decode((Object)buf);
            this.gridDefs.put(loc, gridDef);
        }
    }

    public static void encode(UpdateLinguisticsGridConfigPacketNeoforge message, FriendlyByteBuf buf) {
        buf.writeVarInt(message.gridDefs.size());
        for (Map.Entry<ResourceLocation, GridDefinition> entry : message.gridDefs.entrySet()) {
            buf.writeResourceLocation(entry.getKey());
            GridDefinition.streamCodec().encode((Object)buf, (Object)entry.getValue());
        }
    }

    public static UpdateLinguisticsGridConfigPacketNeoforge decode(FriendlyByteBuf buf) {
        return new UpdateLinguisticsGridConfigPacketNeoforge(buf);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(UpdateLinguisticsGridConfigPacketNeoforge message, IPayloadContext context) {
        ((CompletableFuture)context.enqueueWork(() -> GridDefinitionLoader.getOrCreateInstance().replaceGridDefinitions(message.gridDefs)).exceptionally(e -> {
            LOGGER.error("Config task failed to replace linguistics grid data");
            context.disconnect((Component)Component.literal((String)"Config task failed to replace linguistics grid data"));
            return null;
        })).thenAccept($ -> context.reply((CustomPacketPayload)AcknowledgeLinguisticsGridConfigPacketNeoforge.INSTANCE));
    }
}

