/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.config;

import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.affinities.AffinityType;
import com.verdantartifice.primalmagick.common.affinities.IAffinity;
import com.verdantartifice.primalmagick.common.affinities.IAffinitySerializer;
import com.verdantartifice.primalmagick.common.network.packets.config.AcknowledgeAffinitiesConfigPacketNeoforge;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateAffinitiesConfigPacketNeoforge
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<UpdateAffinitiesConfigPacketNeoforge> TYPE = new CustomPacketPayload.Type(ResourceUtils.loc("update_affinities_neoforge"));
    public static final StreamCodec<FriendlyByteBuf, UpdateAffinitiesConfigPacketNeoforge> STREAM_CODEC = StreamCodec.ofMember(UpdateAffinitiesConfigPacketNeoforge::encode, UpdateAffinitiesConfigPacketNeoforge::decode);
    private static final Logger LOGGER = LogManager.getLogger();
    protected final List<IAffinity> affinities;

    public UpdateAffinitiesConfigPacketNeoforge(Collection<IAffinity> affinities) {
        this.affinities = new ArrayList<IAffinity>(affinities);
    }

    public static void encode(UpdateAffinitiesConfigPacketNeoforge message, FriendlyByteBuf buf) {
        buf.writeCollection(message.affinities, UpdateAffinitiesConfigPacketNeoforge::toNetwork);
    }

    public static UpdateAffinitiesConfigPacketNeoforge decode(FriendlyByteBuf buf) {
        return new UpdateAffinitiesConfigPacketNeoforge(buf.readList(UpdateAffinitiesConfigPacketNeoforge::fromNetwork));
    }

    public static IAffinity fromNetwork(FriendlyByteBuf buf) {
        String typeStr = buf.readUtf();
        AffinityType type = AffinityType.parse(typeStr);
        IAffinitySerializer<?> serializer = AffinityManager.getSerializer(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown affinity serializer " + typeStr);
        }
        return serializer.fromNetwork(buf);
    }

    public static <T extends IAffinity> void toNetwork(FriendlyByteBuf buf, T affinity) {
        buf.writeUtf(affinity.getType().getSerializedName());
        affinity.getSerializer().toNetwork(buf, affinity);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(UpdateAffinitiesConfigPacketNeoforge message, IPayloadContext context) {
        ((CompletableFuture)context.enqueueWork(() -> AffinityManager.getOrCreateInstance().replaceAffinities(message.affinities)).exceptionally(e -> {
            LOGGER.error("Config task failed to replace affinity data");
            context.disconnect((Component)Component.literal((String)"Config task failed to replace affinity data"));
            return null;
        })).thenAccept($ -> context.reply((CustomPacketPayload)AcknowledgeAffinitiesConfigPacketNeoforge.INSTANCE));
    }
}

