/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.misc;

import com.verdantartifice.primalmagick.common.capabilities.IEntitySwappers;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.WandPoofPacket;
import com.verdantartifice.primalmagick.common.util.INBTSerializablePM;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.util.Collection;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class EntitySwapper
implements INBTSerializablePM<CompoundTag> {
    protected EntityType<?> entityType = null;
    protected CompoundTag originalData = null;
    protected Optional<Integer> polymorphDuration = Optional.empty();
    protected int delay = 0;

    protected EntitySwapper() {
    }

    public EntitySwapper(@Nonnull EntityType<?> entityType, @Nullable CompoundTag originalData, @Nonnull Optional<Integer> polymorphDuration, int delay) {
        this.entityType = entityType;
        this.originalData = originalData;
        this.polymorphDuration = polymorphDuration;
        this.delay = delay;
    }

    public EntitySwapper(HolderLookup.Provider registries, CompoundTag tag) {
        this();
        this.deserializeNBT(registries, tag);
    }

    public static boolean enqueue(@Nonnull Entity entity, @Nullable EntitySwapper swapper) {
        if (swapper == null) {
            return false;
        }
        return Services.CAPABILITIES.swappers(entity).map(swappers -> swappers.enqueue(swapper)).orElse(false);
    }

    @Nullable
    public static Queue<EntitySwapper> getSwapperQueue(@Nonnull Entity entity) {
        return Services.CAPABILITIES.swappers(entity).map(IEntitySwappers::getQueue).orElse(null);
    }

    public static boolean setSwapperQueue(@Nonnull Entity entity, @Nonnull Queue<EntitySwapper> swapperQueue) {
        return Services.CAPABILITIES.swappers(entity).map(swappers -> swappers.setQueue(swapperQueue)).orElse(false);
    }

    public void execute(@Nonnull Entity entity) {
        Level world = entity.level();
        if (!world.isClientSide && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (this.isValid() && this.isValidTarget(entity)) {
                LivingEntity livingTarget = (LivingEntity)entity;
                CompoundTag currentData = livingTarget.saveWithoutId(new CompoundTag());
                if (livingTarget.isPassenger()) {
                    livingTarget.stopRiding();
                }
                if (livingTarget.isVehicle()) {
                    livingTarget.ejectPassengers();
                }
                EntityType oldType = livingTarget.getType();
                Vec3 targetPos = livingTarget.position();
                Vec2 targetRots = livingTarget.getRotationVector();
                Component customName = livingTarget.getCustomName();
                boolean customNameVisible = livingTarget.isCustomNameVisible();
                double healthPercentage = (double)livingTarget.getHealth() / (double)livingTarget.getMaxHealth();
                Collection activeEffects = livingTarget.getActiveEffects();
                CompoundTag data = this.originalData == null ? currentData : currentData.merge(this.pruneData(this.originalData, this.polymorphDuration.isPresent()));
                PacketHandler.sendToAllAround(new WandPoofPacket(targetPos.x, targetPos.y, targetPos.z, Color.WHITE.getRGB(), true, Direction.UP), serverWorld, BlockPos.containing((Position)targetPos), 32.0);
                livingTarget.discard();
                Entity newEntity = this.entityType.spawn(serverWorld, e -> {
                    if (!data.isEmpty()) {
                        e.load(data);
                    }
                }, BlockPos.containing((Position)targetPos), MobSpawnType.MOB_SUMMONED, false, false);
                if (newEntity != null) {
                    newEntity.setCustomName(customName);
                    newEntity.setCustomNameVisible(customNameVisible);
                    newEntity.absMoveTo(targetPos.x, targetPos.y, targetPos.z, targetRots.y, targetRots.x);
                    serverWorld.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, targetPos);
                }
                if (newEntity instanceof LivingEntity) {
                    LivingEntity newLivingEntity = (LivingEntity)newEntity;
                    newLivingEntity.setHealth((float)(healthPercentage * (double)newLivingEntity.getMaxHealth()));
                    for (MobEffectInstance activeEffect : activeEffects) {
                        newLivingEntity.addEffect(activeEffect);
                    }
                }
                if (this.polymorphDuration.isPresent()) {
                    int ticks = this.polymorphDuration.get();
                    if (newEntity instanceof LivingEntity) {
                        LivingEntity newLivingEntity = (LivingEntity)newEntity;
                        newLivingEntity.addEffect(new MobEffectInstance(EffectsPM.POLYMORPH.getHolder(), ticks));
                        EntitySwapper.enqueue((Entity)newLivingEntity, new EntitySwapper(oldType, this.originalData, Optional.empty(), ticks));
                    }
                }
            }
        }
    }

    protected boolean isValidTarget(Entity entity) {
        return entity instanceof LivingEntity && !(entity instanceof Player);
    }

    public void decrementDelay() {
        --this.delay;
    }

    public boolean isReady() {
        return this.delay <= 0;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        if (this.entityType != null) {
            nbt.putString("EntityType", EntityType.getKey(this.entityType).toString());
        }
        if (this.originalData != null) {
            nbt.put("OriginalData", (Tag)this.originalData);
        }
        if (this.polymorphDuration != null && this.polymorphDuration.isPresent()) {
            nbt.putInt("PolymorphDuration", this.polymorphDuration.get().intValue());
        }
        nbt.putInt("Delay", this.delay);
        return nbt;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        if (nbt.contains("EntityType")) {
            this.entityType = EntityType.byString((String)nbt.getString("EntityType")).orElse(null);
        }
        if (nbt.contains("OriginalData")) {
            this.originalData = nbt.getCompound("OriginalData");
        }
        this.polymorphDuration = nbt.contains("PolymorphDuration") ? Optional.of(nbt.getInt("PolymorphDuration")) : Optional.empty();
        this.delay = nbt.getInt("Delay");
    }

    public boolean isValid() {
        return this.entityType != null;
    }

    @Nonnull
    protected CompoundTag pruneData(CompoundTag data, boolean initialSwap) {
        CompoundTag prunedData = new CompoundTag();
        prunedData.merge(data);
        prunedData.remove("id");
        prunedData.remove("UUIDMost");
        prunedData.remove("UUIDLeast");
        if (initialSwap) {
            prunedData.remove("Health");
            prunedData.remove("Attributes");
            prunedData.remove("ActiveEffects");
        } else {
            prunedData.remove("Pos");
            prunedData.remove("Motion");
            prunedData.remove("Rotation");
            prunedData.remove("FallDistance");
            prunedData.remove("Fire");
            prunedData.remove("Air");
            prunedData.remove("OnGround");
            prunedData.remove("Glowing");
            prunedData.remove("Health");
            prunedData.remove("AbsorptionAmount");
            prunedData.remove("DeathTime");
            prunedData.remove("Attributes");
            prunedData.remove("ActiveEffects");
        }
        return prunedData;
    }
}

