/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.misc;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.WandPoofPacket;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockSwapper {
    protected static final Map<ResourceLocation, Queue<BlockSwapper>> REGISTRY = new HashMap<ResourceLocation, Queue<BlockSwapper>>();
    protected final BlockPos pos;
    protected final BlockState source;
    protected final ItemStack target;
    protected final Player player;

    public BlockSwapper(@Nonnull BlockPos pos, @Nullable BlockState source, @Nullable ItemStack target, @Nonnull Player player) {
        this.pos = pos;
        this.source = source;
        this.target = target;
        this.player = player;
    }

    public static boolean enqueue(@Nonnull Level world, @Nullable BlockSwapper swapper) {
        if (swapper == null) {
            return false;
        }
        return BlockSwapper.getWorldSwappers(world).offer(swapper);
    }

    @Nonnull
    public static Queue<BlockSwapper> getWorldSwappers(@Nonnull Level world) {
        return REGISTRY.computeIfAbsent(world.dimension().location(), key -> new LinkedBlockingQueue());
    }

    public void execute(Level world) {
        boolean allow;
        BlockState state = world.getBlockState(this.pos);
        boolean bl = allow = state.getDestroySpeed((BlockGetter)world, this.pos) >= 0.0f && (this.source == null || this.source.equals(state));
        if (allow && world.mayInteract(this.player, this.pos) && this.isTargetDifferent(state) && this.canPlace(world, state)) {
            if (this.target == null || this.target.isEmpty()) {
                world.removeBlock(this.pos, false);
            } else {
                Block targetBlock = Block.byItem((Item)this.target.getItem());
                if (targetBlock != null && targetBlock != Blocks.AIR) {
                    BlockState targetState = targetBlock.defaultBlockState();
                    if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                        targetState = (BlockState)targetState.setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.FACING)));
                    } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        targetState = (BlockState)targetState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
                    }
                    world.setBlock(this.pos, targetState, 3);
                    BlockEntity blockEntity = world.getBlockEntity(this.pos);
                    if (blockEntity instanceof IOwnedTileEntity) {
                        IOwnedTileEntity ownedTile = (IOwnedTileEntity)blockEntity;
                        ownedTile.setTileOwner(this.player);
                    }
                } else {
                    world.removeBlock(this.pos, false);
                    ItemEntity entity = new ItemEntity(world, (double)this.pos.getX() + 0.5, (double)this.pos.getY(), (double)this.pos.getZ() + 0.5, this.target.copy());
                    entity.setDeltaMovement(0.0, 0.0, 0.0);
                    world.addFreshEntity((Entity)entity);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    PacketHandler.sendToAllAround(new WandPoofPacket(this.pos, Color.WHITE.getRGB(), true, Direction.UP), serverLevel, this.pos, 32.0);
                }
            }
        }
    }

    protected boolean isTargetDifferent(BlockState sourceState) {
        return this.target == null || this.target.isEmpty() || !ItemStack.isSameItem((ItemStack)this.target, (ItemStack)new ItemStack((ItemLike)sourceState.getBlock()));
    }

    protected boolean canPlace(Level world, BlockState state) {
        return !Services.EVENTS.onBlockPlace((Entity)this.player, world, this.pos, Direction.UP);
    }
}

