/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.misc;

import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBreaker {
    protected static final Map<ResourceLocation, ConcurrentNavigableMap<Integer, Map<BlockPos, BlockBreaker>>> SCHEDULE = new ConcurrentHashMap<ResourceLocation, ConcurrentNavigableMap<Integer, Map<BlockPos, BlockBreaker>>>();
    protected final float power;
    protected final BlockPos pos;
    protected final BlockState targetBlock;
    protected final float currentDurability;
    protected final float maxDurability;
    protected final Player player;
    protected final ItemStack tool;
    protected final boolean oneShot;
    protected final boolean skipEvent;
    protected final boolean alwaysDrop;
    protected final Optional<Boolean> silkTouchOverride;
    protected final Optional<Integer> fortuneOverride;

    protected BlockBreaker(float power, @Nonnull BlockPos pos, @Nonnull BlockState targetBlock, float currentDurability, float maxDurability, @Nonnull Player player, ItemStack tool, boolean oneShot, boolean skipEvent, boolean alwaysDrop, Optional<Boolean> silkTouchOverride, Optional<Integer> fortuneOverride) {
        this.power = power;
        this.pos = pos;
        this.targetBlock = targetBlock;
        this.currentDurability = currentDurability;
        this.maxDurability = maxDurability;
        this.player = player;
        this.tool = tool;
        this.oneShot = oneShot;
        this.skipEvent = skipEvent;
        this.alwaysDrop = alwaysDrop;
        this.silkTouchOverride = silkTouchOverride;
        this.fortuneOverride = fortuneOverride;
    }

    public static boolean schedule(@Nonnull Level world, int delayTicks, @Nullable BlockBreaker breaker) {
        if (breaker == null) {
            return false;
        }
        int delay = Math.max(0, delayTicks);
        SCHEDULE.computeIfAbsent(world.dimension().location(), key -> new ConcurrentSkipListMap()).computeIfAbsent(delay, key -> new ConcurrentHashMap()).put(breaker.pos, breaker);
        return true;
    }

    public static Iterable<BlockBreaker> tick(@Nonnull Level world) {
        ConcurrentNavigableMap<Integer, Map<BlockPos, BlockBreaker>> tree = SCHEDULE.get(world.dimension().location());
        if (tree == null) {
            return Collections.emptyList();
        }
        Collection<BlockBreaker> retVal = Collections.emptyList();
        ConcurrentSkipListMap<Integer, Map> newTree = new ConcurrentSkipListMap<Integer, Map>();
        while (!tree.isEmpty()) {
            Map.Entry entry = tree.pollFirstEntry();
            if ((Integer)entry.getKey() <= 0) {
                retVal = ((Map)entry.getValue()).values();
                continue;
            }
            newTree.put((Integer)entry.getKey() - 1, (Map)entry.getValue());
        }
        if (!newTree.isEmpty()) {
            SCHEDULE.put(world.dimension().location(), newTree);
        }
        return retVal;
    }

    public static boolean hasBreakerQueued(@Nonnull Level world, @Nonnull BlockPos pos) {
        ConcurrentNavigableMap<Integer, Map<BlockPos, BlockBreaker>> tree = SCHEDULE.get(world.dimension().location());
        if (tree != null) {
            for (Map tickMap : tree.values()) {
                if (!tickMap.keySet().contains(pos)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public BlockBreaker execute(@Nonnull Level world) {
        BlockBreaker retVal = null;
        BlockState state = world.getBlockState(this.pos);
        if (state == this.targetBlock && world.mayInteract(this.player, this.pos) && state.getDestroySpeed((BlockGetter)world, this.pos) >= 0.0f) {
            world.destroyBlockProgress(this.pos.hashCode(), this.pos, (int)((1.0f - this.currentDurability / this.maxDurability) * 10.0f));
            float newDurability = this.currentDurability - this.power;
            if (newDurability <= 0.0f) {
                this.doHarvest(world);
                world.destroyBlockProgress(this.pos.hashCode(), this.pos, -1);
            } else if (!this.oneShot) {
                retVal = new Builder(this).currentDurability(newDurability).build();
            }
        }
        return retVal;
    }

    protected boolean doHarvest(@Nonnull Level world) {
        Player player;
        if (!world.isClientSide && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (world instanceof ServerLevel) {
                int exp;
                ServerLevel serverWorld = (ServerLevel)world;
                int n = exp = this.skipEvent ? 0 : Services.EVENTS.fireBlockBreakEvent(world, serverPlayer.gameMode.getGameModeForPlayer(), serverPlayer, this.pos);
                if (exp == -1) {
                    return false;
                }
                BlockEntity tile = world.getBlockEntity(this.pos);
                BlockState state = world.getBlockState(this.pos);
                Block block = state.getBlock();
                if (exp == 0 && !Services.EVENTS.isCorrectToolForDrops(this.player, state, world, this.pos)) {
                    exp = Services.BLOCK_STATES.getExpDrop(state, world, this.pos, (Entity)this.player, this.getHarvestTool(this.player));
                }
                if (block instanceof GameMasterBlock && !serverPlayer.canUseGameMasterBlocks()) {
                    world.sendBlockUpdated(this.pos, state, state, 3);
                    return false;
                }
                if (Services.ITEM_STACKS.onBlockStartBreak(serverPlayer.getMainHandItem(), this.pos, (Player)serverPlayer)) {
                    return false;
                }
                if (serverPlayer.blockActionRestricted(world, this.pos, serverPlayer.gameMode.getGameModeForPlayer())) {
                    return false;
                }
                world.levelEvent(null, 2001, this.pos, Block.getId((BlockState)state));
                if (serverPlayer.gameMode.isCreative()) {
                    this.removeBlock(world, false);
                    return true;
                }
                boolean canHarvest = this.alwaysDrop || Services.BLOCK_STATES.canHarvestBlock(state, (BlockGetter)world, this.pos, (Player)serverPlayer);
                boolean success = this.removeBlock(world, canHarvest);
                if (success && canHarvest) {
                    block.playerDestroy(world, (Player)serverPlayer, this.pos, state, tile, this.getHarvestTool((Player)serverPlayer));
                }
                if (success && exp > 0) {
                    block.popExperience(serverWorld, this.pos, exp);
                }
                return true;
            }
        }
        return false;
    }

    protected ItemStack getHarvestTool(Player player) {
        ItemStack stack = this.tool.copy();
        if (stack.isEmpty()) {
            stack = player.getMainHandItem().copy();
        }
        if (this.silkTouchOverride.isPresent() || this.fortuneOverride.isPresent()) {
            HolderLookup.RegistryLookup enchHolderLookup = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(stack.getEnchantments());
            enchHolderLookup.get(Enchantments.SILK_TOUCH).ifPresent(silkTouchHolder -> this.silkTouchOverride.filter(silk -> silk).ifPresent($ -> enchantments.upgrade((Holder)silkTouchHolder, 1)));
            enchHolderLookup.get(Enchantments.FORTUNE).ifPresent(fortuneHolder -> this.fortuneOverride.filter(fortune -> fortune > 0).ifPresent(fortune -> enchantments.upgrade((Holder)fortuneHolder, fortune.intValue())));
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)enchantments.toImmutable());
        }
        return stack;
    }

    protected boolean removeBlock(@Nonnull Level world, boolean canHarvest) {
        BlockState state = world.getBlockState(this.pos);
        boolean removed = Services.BLOCK_STATES.onDestroyedByPlayer(state, world, this.pos, this.player, canHarvest, world.getFluidState(this.pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)world, this.pos, state);
        }
        return removed;
    }

    public static class Builder {
        protected float power = 0.0f;
        protected BlockPos pos = BlockPos.ZERO;
        protected BlockState targetBlock = null;
        protected float currentDurability = 0.0f;
        protected float maxDurability = 0.0f;
        protected Player player = null;
        protected ItemStack tool = ItemStack.EMPTY;
        protected boolean oneShot = false;
        protected boolean skipEvent = false;
        protected boolean alwaysDrop = false;
        protected Optional<Boolean> silkTouchOverride = Optional.empty();
        protected Optional<Integer> fortuneOverride = Optional.empty();

        public Builder() {
        }

        public Builder(BlockBreaker existing) {
            this.power = existing.power;
            this.pos = existing.pos;
            this.targetBlock = existing.targetBlock;
            this.currentDurability = existing.currentDurability;
            this.maxDurability = existing.maxDurability;
            this.player = existing.player;
            this.tool = existing.tool;
            this.oneShot = existing.oneShot;
            this.skipEvent = existing.skipEvent;
            this.alwaysDrop = existing.alwaysDrop;
            this.silkTouchOverride = existing.silkTouchOverride;
            this.fortuneOverride = existing.fortuneOverride;
        }

        public Builder power(float power) {
            this.power = power;
            return this;
        }

        public Builder target(BlockPos pos, BlockState targetBlock) {
            this.pos = pos;
            this.targetBlock = targetBlock;
            return this;
        }

        public Builder durability(float max) {
            return this.durability(max, max);
        }

        public Builder durability(float current, float max) {
            this.currentDurability = current;
            this.maxDurability = max;
            return this;
        }

        public Builder currentDurability(float current) {
            this.currentDurability = current;
            return this;
        }

        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        public Builder tool(ItemStack tool) {
            this.tool = tool;
            return this;
        }

        public Builder oneShot() {
            this.oneShot = true;
            return this;
        }

        public Builder skipEvent() {
            this.skipEvent = true;
            return this;
        }

        public Builder alwaysDrop() {
            this.alwaysDrop = true;
            return this;
        }

        public Builder silkTouch(boolean silk) {
            this.silkTouchOverride = Optional.of(silk);
            return this;
        }

        public Builder fortune(int fortune) {
            this.fortuneOverride = Optional.of(fortune);
            return this;
        }

        private void validate() {
            if (this.targetBlock == null) {
                throw new IllegalStateException("Missing target block in BlockBreaker builder!");
            }
            if (this.player == null) {
                throw new IllegalStateException("Missing player in BlockBreaker builder!");
            }
            if (this.tool == null) {
                throw new IllegalStateException("Invalid tool in BlockBreaker builder!");
            }
        }

        public BlockBreaker build() {
            this.validate();
            return new BlockBreaker(this.power, this.pos, this.targetBlock, this.currentDurability, this.maxDurability, this.player, this.tool, this.oneShot, this.skipEvent, this.alwaysDrop, this.silkTouchOverride, this.fortuneOverride);
        }
    }
}

