/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus.slots;

import com.verdantartifice.primalmagick.common.crafting.WandInventory;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SpellcraftingResultSlot
extends ResultSlot {
    protected final WandInventory wandInventory;
    protected final Player player;
    protected final Supplier<SourceList> costSupplier;
    protected int amountCrafted;

    public SpellcraftingResultSlot(Player player, CraftingContainer craftingInventory, WandInventory wandInventory, Supplier<SourceList> costSupplier, Container inventoryIn, int slotIndex, int xPosition, int yPosition) {
        super(player, craftingInventory, inventoryIn, slotIndex, xPosition, yPosition);
        this.wandInventory = wandInventory;
        this.player = player;
        this.costSupplier = costSupplier;
    }

    public void onTake(Player player, ItemStack stack) {
        Item item;
        ItemStack wandStack;
        SourceList manaCosts = this.costSupplier.get();
        if (manaCosts != null && !manaCosts.isEmpty() && (wandStack = this.wandInventory.getItem(0)) != null && !wandStack.isEmpty() && (item = wandStack.getItem()) instanceof IWand) {
            IWand wand = (IWand)item;
            wand.consumeMana(wandStack, this.player, manaCosts, (HolderLookup.Provider)player.registryAccess());
        }
        super.onTake(player, stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        super.checkTakeAchievements(stack);
        if (this.amountCrafted > 0) {
            StatsManager.incrementValue(this.player, StatsPM.CRAFTED_SORCERY, this.amountCrafted);
        }
        this.amountCrafted = 0;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        super.onQuickCraft(stack, amount);
    }

    protected void onSwapCraft(int amount) {
        this.amountCrafted += amount;
        super.onSwapCraft(amount);
    }
}

