/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus.slots;

import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentKey;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class RunescribingResultSlot
extends Slot {
    protected final Player player;
    protected final Container inputInventory;

    public RunescribingResultSlot(Player player, Container inputInv, Container outputInv, int index, int xPosition, int yPosition) {
        super(outputInv, index, xPosition, yPosition);
        this.player = player;
        this.inputInventory = inputInv;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    protected void checkTakeAchievements(ItemStack stack) {
        super.checkTakeAchievements(stack);
        Level level = this.player.level();
        if (!level.isClientSide) {
            List<Rune> runes = RuneManager.getRunes(stack);
            Map<Holder<Enchantment>, Integer> enchants = RuneManager.getRuneEnchantments(level.registryAccess(), runes, stack, this.player, false);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                StatsManager.incrementValue((Player)serverPlayer, StatsPM.ITEMS_RUNESCRIBED, stack.getCount());
                enchants.keySet().forEach(enchant -> CriteriaTriggersPM.RUNESCRIBING.get().trigger(serverPlayer, (Holder<Enchantment>)enchant));
                Map outputFrequencyMap = enchants.keySet().stream().filter(ench -> RuneManager.hasRuneDefinition(level.registryAccess(), (Holder<Enchantment>)ench)).flatMap(ench -> RuneManager.getRuneDefinition(level.registryAccess(), (Holder<Enchantment>)ench).get().getRunes().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.summingInt(element -> 1)));
                Map inputFrequencyMap = runes.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.summingInt(element -> 1)));
                inputFrequencyMap.entrySet().stream().map(entry -> Map.entry((Rune)entry.getKey(), Math.max(0, 1 + outputFrequencyMap.getOrDefault(entry.getKey(), 0) - (Integer)inputFrequencyMap.get(entry.getKey())))).forEach(entry -> CriteriaTriggersPM.RUNE_USE_COUNT.get().trigger(serverPlayer, (Rune)entry.getKey(), (Integer)entry.getValue()));
            }
            if (!enchants.isEmpty() && !ResearchManager.isResearchComplete(this.player, ResearchEntries.UNLOCK_RUNE_ENCHANTMENTS)) {
                ResearchManager.completeResearch(this.player, ResearchEntries.UNLOCK_RUNE_ENCHANTMENTS);
            }
            enchants.keySet().forEach(enchant -> ResearchManager.completeResearch(this.player, new RuneEnchantmentKey((Holder<Enchantment>)enchant)));
        }
    }

    public void onTake(Player thePlayer, ItemStack stack) {
        this.checkTakeAchievements(stack);
        for (int index = 0; index < this.inputInventory.getContainerSize(); ++index) {
            ItemStack materialStack = this.inputInventory.getItem(index);
            if (materialStack.isEmpty()) continue;
            this.inputInventory.removeItem(index, 1);
        }
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.checkTakeAchievements(stack);
    }
}

