/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus.slots;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FilteredSlotProperties {
    private final List<Pair<Predicate<Slot>, ResourceLocation>> backgrounds = new ArrayList<Pair<Predicate<Slot>, ResourceLocation>>();
    private Optional<Predicate<ItemStack>> filter = Optional.empty();
    private Optional<Component> tooltip = Optional.empty();
    private Optional<Integer> maxStackSize = Optional.empty();

    List<Pair<Predicate<Slot>, ResourceLocation>> getBackgrounds() {
        return this.backgrounds;
    }

    Optional<Predicate<ItemStack>> getFilter() {
        return this.filter;
    }

    Optional<Component> getTooltip() {
        return this.tooltip;
    }

    Optional<Integer> getMaxStackSize() {
        return this.maxStackSize;
    }

    public FilteredSlotProperties filter(Predicate<ItemStack> filter) {
        this.filter = Optional.ofNullable(filter);
        return this;
    }

    public FilteredSlotProperties item(Item item) {
        Objects.requireNonNull(item);
        return this.filter(stack -> stack.is(item));
    }

    public FilteredSlotProperties item(Item ... items) {
        Objects.requireNonNull(items);
        return this.filter(stack -> Stream.of(items).anyMatch(arg_0 -> ((ItemStack)stack).is(arg_0)));
    }

    public FilteredSlotProperties tag(TagKey<Item> tagKey) {
        Objects.requireNonNull(tagKey);
        return this.filter(stack -> stack.is(tagKey));
    }

    public FilteredSlotProperties typeOf(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        return this.filter(stack -> clazz.isInstance(stack.getItem()));
    }

    public FilteredSlotProperties typeOf(Class<?> ... clazzes) {
        Objects.requireNonNull(clazzes);
        return this.filter(stack -> Stream.of(clazzes).anyMatch(clazz -> clazz.isInstance(stack.getItem())));
    }

    public FilteredSlotProperties background(ResourceLocation loc) {
        return this.background(loc, $ -> true);
    }

    public FilteredSlotProperties background(ResourceLocation loc, Predicate<Slot> predicate) {
        this.backgrounds.add((Pair<Predicate<Slot>, ResourceLocation>)Pair.of(predicate, (Object)loc));
        return this;
    }

    public FilteredSlotProperties tooltip(Component tooltip) {
        this.tooltip = Optional.ofNullable(tooltip);
        return this;
    }

    public FilteredSlotProperties stacksTo(int size) {
        this.maxStackSize = Optional.of(size);
        return this;
    }
}

