/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus.slots;

import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.crafting.WandInventory;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ArcaneCraftingResultSlot
extends Slot {
    protected final CraftingContainer craftingInventory;
    protected final WandInventory wandInventory;
    protected final Player player;
    protected int amountCrafted;

    public ArcaneCraftingResultSlot(Player player, CraftingContainer craftingInventory, WandInventory wandInventory, Container inventoryIn, int slotIndex, int xPosition, int yPosition) {
        super(inventoryIn, slotIndex, xPosition, yPosition);
        this.craftingInventory = craftingInventory;
        this.wandInventory = wandInventory;
        this.player = player;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.checkTakeAchievements(stack);
    }

    protected void onSwapCraft(int amount) {
        this.amountCrafted += amount;
    }

    protected void checkTakeAchievements(ItemStack stack) {
        RecipeCraftingHolder recipeHolder;
        Container container;
        if (this.amountCrafted > 0) {
            stack.onCraftedBy(this.player.level(), this.player, this.amountCrafted);
            Services.EVENTS.firePlayerCraftingEvent(this.player, stack, (Container)this.craftingInventory);
            container = this.container;
            if (container instanceof RecipeCraftingHolder && (recipeHolder = (RecipeCraftingHolder)container).getRecipeUsed() != null) {
                ExpertiseManager.awardExpertise(this.player, recipeHolder.getRecipeUsed());
                StatsManager.incrementCraftCount(this.player, recipeHolder.getRecipeUsed(), this.amountCrafted);
            }
        }
        if ((container = this.container) instanceof RecipeCraftingHolder) {
            recipeHolder = (RecipeCraftingHolder)container;
            recipeHolder.awardUsedRecipes(this.player, this.craftingInventory.getItems());
        }
        this.amountCrafted = 0;
    }

    public void onTake(Player thePlayer, ItemStack stack) {
        NonNullList remainingList;
        Item item;
        ItemStack wandStack;
        IArcaneRecipe arcaneRecipe;
        SourceList manaCosts;
        Recipe recipe;
        RecipeCraftingHolder holder;
        this.checkTakeAchievements(stack);
        Container container = this.container;
        if (container instanceof RecipeCraftingHolder && (holder = (RecipeCraftingHolder)container).getRecipeUsed() != null && (recipe = holder.getRecipeUsed().value()) instanceof IArcaneRecipe && !(manaCosts = (arcaneRecipe = (IArcaneRecipe)recipe).getManaCosts()).isEmpty() && (wandStack = this.wandInventory.getItem(0)) != null && !wandStack.isEmpty() && (item = wandStack.getItem()) instanceof IWand) {
            IWand wand = (IWand)item;
            wand.consumeMana(wandStack, this.player, manaCosts, (HolderLookup.Provider)thePlayer.registryAccess());
        }
        CraftingInput.Positioned positionedCraftingInput = this.craftingInventory.asPositionedCraftInput();
        CraftingInput craftingInput = positionedCraftingInput.input();
        int leftBound = positionedCraftingInput.left();
        int topBound = positionedCraftingInput.top();
        Services.EVENTS.setCraftingPlayer(thePlayer);
        Level level = thePlayer.level();
        Optional arcaneOptional = level.getRecipeManager().getRecipeFor(RecipeTypesPM.ARCANE_CRAFTING.get(), (RecipeInput)this.craftingInventory.asCraftInput(), level);
        if (arcaneOptional.isPresent()) {
            remainingList = ((IArcaneRecipe)((RecipeHolder)arcaneOptional.get()).value()).getRemainingItems((RecipeInput)craftingInput);
        } else {
            Optional vanillaOptional = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.craftingInventory.asCraftInput(), level);
            if (vanillaOptional.isPresent()) {
                remainingList = ((CraftingRecipe)((RecipeHolder)vanillaOptional.get()).value()).getRemainingItems((RecipeInput)craftingInput);
            } else {
                remainingList = NonNullList.withSize((int)this.craftingInventory.getContainerSize(), (Object)ItemStack.EMPTY);
                for (int index = 0; index < remainingList.size(); ++index) {
                    remainingList.set(index, (Object)this.craftingInventory.getItem(index));
                }
            }
        }
        Services.EVENTS.setCraftingPlayer(null);
        for (int y = 0; y < craftingInput.height(); ++y) {
            for (int x = 0; x < craftingInput.width(); ++x) {
                int originalIndex = leftBound + x + (topBound + y) * this.craftingInventory.getWidth();
                int remainderIndex = x + y * craftingInput.width();
                ItemStack materialStack = this.craftingInventory.getItem(originalIndex);
                ItemStack remainingStack = (ItemStack)remainingList.get(remainderIndex);
                if (!materialStack.isEmpty()) {
                    this.craftingInventory.removeItem(originalIndex, 1);
                    materialStack = this.craftingInventory.getItem(originalIndex);
                }
                if (remainingStack.isEmpty()) continue;
                if (materialStack.isEmpty()) {
                    this.craftingInventory.setItem(originalIndex, remainingStack);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)materialStack, (ItemStack)remainingStack)) {
                    remainingStack.grow(materialStack.getCount());
                    this.craftingInventory.setItem(originalIndex, remainingStack);
                    continue;
                }
                if (this.player.getInventory().add(remainingStack)) continue;
                this.player.drop(remainingStack, false);
            }
        }
    }
}

