/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.crafting.WandInscriptionRecipe;
import com.verdantartifice.primalmagick.common.items.wands.SpellScrollItem;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.menus.slots.IWandSlot;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.wands.ISpellContainer;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WandInscriptionTableMenu
extends AbstractContainerMenu {
    protected static final Component CASTER_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.wand_inscription_table.slot.caster");
    protected static final Component SCROLL_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.wand_inscription_table.slot.scroll");
    protected static final ResourceLocation TOME_BACKGROUND = ResourceUtils.loc("item/empty_book_slot");
    protected static final ResourceLocation RECIPE_LOC = ResourceUtils.loc("wand_inscription");
    protected final ContainerLevelAccess worldPosCallable;
    protected final InscriptionComponentInventory componentInv = new InscriptionComponentInventory(this);
    protected final ResultContainer resultInv = new ResultContainer();
    protected final Player player;
    protected final Slot wandSlot;
    protected final Slot scrollSlot;

    public WandInscriptionTableMenu(int windowId, Inventory inv) {
        this(windowId, inv, ContainerLevelAccess.NULL);
    }

    public WandInscriptionTableMenu(int windowId, Inventory inv, ContainerLevelAccess callable) {
        super(MenuTypesPM.WAND_INSCRIPTION_TABLE.get(), windowId);
        int i;
        this.worldPosCallable = callable;
        this.player = inv.player;
        IItemHandlerPM componentInvWrapper = Services.ITEM_HANDLERS.wrap((Container)this.componentInv, null);
        this.addSlot((Slot)new ResultSlot(this.player, (CraftingContainer)this.componentInv, (Container)this.resultInv, 0, 124, 35));
        this.wandSlot = this.addSlot(Services.MENU.makeFilteredSlot(componentInvWrapper, 0, 30, 35, new FilteredSlotProperties().typeOf((Class<?>)ISpellContainer.class).tooltip(CASTER_SLOT_TOOLTIP).background(IWandSlot.TEXTURE).background(TOME_BACKGROUND)));
        this.scrollSlot = this.addSlot(Services.MENU.makeFilteredSlot(componentInvWrapper, 1, 66, 35, new FilteredSlotProperties().typeOf((Class<?>)SpellScrollItem.class).tooltip(SCROLL_SLOT_TOOLTIP)));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
    }

    public boolean stillValid(Player playerIn) {
        return WandInscriptionTableMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)BlocksPM.WAND_INSCRIPTION_TABLE.get());
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.clearContainer(playerIn, (Container)this.componentInv);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(slotStack, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index >= 3 && index < 30 ? (this.wandSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.scrollSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : !this.moveItemStackTo(slotStack, 30, 39, false))) : (index >= 30 && index < 39 ? (this.wandSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.scrollSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : !this.moveItemStackTo(slotStack, 3, 30, false))) : !this.moveItemStackTo(slotStack, 3, 39, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return stack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.resultInv && super.canTakeItemForPickAll(stack, slotIn);
    }

    public void slotsChanged(Container inventoryIn) {
        super.slotsChanged(inventoryIn);
        this.worldPosCallable.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected void slotChangedCraftingGrid(Level world) {
        if (!world.isClientSide && this.player instanceof ServerPlayer) {
            WandInscriptionRecipe recipe;
            Recipe recipe2;
            ServerPlayer spe = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.EMPTY;
            Optional opt = world.getServer().getRecipeManager().byKey(RECIPE_LOC);
            if (opt.isPresent() && (recipe2 = ((RecipeHolder)opt.get()).value()) instanceof WandInscriptionRecipe && (recipe = (WandInscriptionRecipe)recipe2).matches(this.componentInv.asCraftInput(), world)) {
                stack = recipe.assemble(this.componentInv.asCraftInput(), (HolderLookup.Provider)world.registryAccess());
            }
            this.resultInv.setItem(0, stack);
            spe.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, stack));
        }
    }

    protected class InscriptionComponentInventory
    extends TransientCraftingContainer {
        public InscriptionComponentInventory(WandInscriptionTableMenu this$0) {
            super((AbstractContainerMenu)this$0, 2, 1);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

