/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.crafting.WandAssemblyRecipe;
import com.verdantartifice.primalmagick.common.items.wands.StaffCoreItem;
import com.verdantartifice.primalmagick.common.items.wands.WandCapItem;
import com.verdantartifice.primalmagick.common.items.wands.WandCoreItem;
import com.verdantartifice.primalmagick.common.items.wands.WandGemItem;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WandAssemblyTableMenu
extends AbstractContainerMenu {
    public static final ResourceLocation CAP_SLOT_TEXTURE = ResourceUtils.loc("item/empty_wand_cap_slot");
    public static final ResourceLocation CORE_SLOT_TEXTURE = ResourceUtils.loc("item/empty_wand_core_slot");
    public static final ResourceLocation GEM_SLOT_TEXTURE = ResourceUtils.loc("item/empty_wand_gem_slot");
    protected static final Component CORE_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.wand_assembly_table.slot.core");
    protected static final Component CAP_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.wand_assembly_table.slot.cap");
    protected static final Component GEM_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.wand_assembly_table.slot.gem");
    protected static final ResourceLocation RECIPE_LOC = ResourceUtils.loc("wand_assembly");
    protected final ContainerLevelAccess worldPosCallable;
    protected final WandComponentInventory componentInv = new WandComponentInventory(this);
    protected final ResultContainer resultInv = new ResultContainer();
    protected final Player player;
    protected final Slot coreSlot;
    protected final Slot capSlot;
    protected final Slot gemSlot;

    public WandAssemblyTableMenu(int windowId, Inventory inv) {
        this(windowId, inv, ContainerLevelAccess.NULL);
    }

    public WandAssemblyTableMenu(int windowId, Inventory inv, ContainerLevelAccess callable) {
        super(MenuTypesPM.WAND_ASSEMBLY_TABLE.get(), windowId);
        int i;
        this.worldPosCallable = callable;
        this.player = inv.player;
        IItemHandlerPM componentInvWrapper = Services.ITEM_HANDLERS.wrap((Container)this.componentInv, null);
        this.addSlot((Slot)new ResultSlot(this.player, (CraftingContainer)this.componentInv, (Container)this.resultInv, 0, 124, 35));
        this.coreSlot = this.addSlot(Services.MENU.makeFilteredSlot(componentInvWrapper, 0, 48, 35, new FilteredSlotProperties().background(CORE_SLOT_TEXTURE).tooltip(CORE_SLOT_TOOLTIP).typeOf(WandCoreItem.class, StaffCoreItem.class)));
        this.gemSlot = this.addSlot(Services.MENU.makeFilteredSlot(componentInvWrapper, 1, 48, 17, new FilteredSlotProperties().background(GEM_SLOT_TEXTURE).tooltip(GEM_SLOT_TOOLTIP).typeOf((Class<?>)WandGemItem.class)));
        this.capSlot = this.addSlot(WandAssemblyTableMenu.makeCapSlot(componentInvWrapper, 2, 30, 53));
        this.addSlot(WandAssemblyTableMenu.makeCapSlot(componentInvWrapper, 3, 66, 17));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
    }

    protected static Slot makeCapSlot(IItemHandlerPM inventoryIn, int index, int xPosition, int yPosition) {
        return Services.MENU.makeFilteredSlot(inventoryIn, index, xPosition, yPosition, new FilteredSlotProperties().background(CAP_SLOT_TEXTURE).tooltip(CAP_SLOT_TOOLTIP).typeOf((Class<?>)WandCapItem.class));
    }

    public boolean stillValid(Player playerIn) {
        return WandAssemblyTableMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)BlocksPM.WAND_ASSEMBLY_TABLE.get());
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.clearContainer(playerIn, (Container)this.componentInv);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(slotStack, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index >= 5 && index < 32 ? (this.coreSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.gemSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : (this.capSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 3, 5, false) : !this.moveItemStackTo(slotStack, 32, 41, false)))) : (index >= 32 && index < 41 ? (this.coreSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.gemSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : (this.capSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 3, 5, false) : !this.moveItemStackTo(slotStack, 5, 32, false)))) : !this.moveItemStackTo(slotStack, 5, 41, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return stack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.resultInv && super.canTakeItemForPickAll(stack, slotIn);
    }

    public void slotsChanged(Container inventoryIn) {
        super.slotsChanged(inventoryIn);
        this.worldPosCallable.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected void slotChangedCraftingGrid(Level world) {
        if (!world.isClientSide && this.player instanceof ServerPlayer) {
            WandAssemblyRecipe recipe;
            Recipe recipe2;
            ServerPlayer spe = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.EMPTY;
            Optional opt = world.getServer().getRecipeManager().byKey(RECIPE_LOC);
            if (opt.isPresent() && (recipe2 = ((RecipeHolder)opt.get()).value()) instanceof WandAssemblyRecipe && (recipe = (WandAssemblyRecipe)recipe2).matches(this.componentInv.asCraftInput(), world)) {
                stack = recipe.assemble(this.componentInv.asCraftInput(), (HolderLookup.Provider)world.registryAccess());
            }
            this.resultInv.setItem(0, stack);
            spe.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, stack));
        }
    }

    protected class WandComponentInventory
    extends TransientCraftingContainer {
        public WandComponentInventory(WandAssemblyTableMenu this$0) {
            super((AbstractContainerMenu)this$0, 4, 1);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

