/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.crafting.SpellcraftingRecipe;
import com.verdantartifice.primalmagick.common.crafting.WandInventory;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.wands.SpellScrollItem;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.menus.slots.SpellcraftingResultSlot;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.spells.SpellComponent;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.ConfiguredSpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.SpellModType;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.ConfiguredSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.EmptySpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.SpellPayloadType;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.ConfiguredSpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.EmptySpellVehicle;
import com.verdantartifice.primalmagick.common.spells.vehicles.SpellVehicleType;
import com.verdantartifice.primalmagick.common.tiles.crafting.SpellcraftingAltarTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SpellcraftingAltarMenu
extends AbstractTileMenu<SpellcraftingAltarTileEntity> {
    protected static final ResourceLocation RECIPE_LOC = ResourceUtils.loc("spellcrafting");
    protected static final Component SCROLL_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.spellcrafting_altar.slot.scroll");
    protected final CraftingContainer scrollInv = new TransientCraftingContainer((AbstractContainerMenu)this, 1, 1);
    protected final WandInventory wandInv = new WandInventory(this);
    protected final ResultContainer resultInv = new ResultContainer();
    protected final Player player;
    protected final Slot wandSlot;
    protected final Slot scrollSlot;
    protected String spellName = "";
    protected int spellVehicleTypeIndex = 0;
    protected int spellPayloadTypeIndex = 0;
    protected int spellPrimaryModTypeIndex = 0;
    protected int spellSecondaryModTypeIndex = 0;
    protected SpellPackage spellPackageCache = null;
    protected Map<SpellComponent, Map<SpellProperty, Integer>> spellPropertyCache = new HashMap<SpellComponent, Map<SpellProperty, Integer>>();

    public SpellcraftingAltarMenu(int windowId, Inventory inv, BlockPos tilePos) {
        this(windowId, inv, tilePos, null);
    }

    public SpellcraftingAltarMenu(int windowId, Inventory inv, BlockPos tilePos, SpellcraftingAltarTileEntity altar) {
        super(MenuTypesPM.SPELLCRAFTING_ALTAR.get(), windowId, SpellcraftingAltarTileEntity.class, inv.player.level(), tilePos, altar);
        int i;
        this.player = inv.player;
        for (SpellComponent comp : SpellComponent.values()) {
            this.spellPropertyCache.put(comp, new HashMap());
        }
        this.addSlot((Slot)new SpellcraftingResultSlot(this.player, this.scrollInv, this.wandInv, this::getManaCosts, (Container)this.resultInv, 0, 206, 8));
        this.wandSlot = this.addSlot(Services.MENU.makeWandSlot(Services.ITEM_HANDLERS.wrap(this.wandInv, null), 0, 8, 8, false));
        this.scrollSlot = this.addSlot(Services.MENU.makeFilteredSlot(Services.ITEM_HANDLERS.wrap((Container)this.scrollInv, null), 0, 160, 8, new FilteredSlotProperties().item(ItemsPM.SPELL_SCROLL_BLANK.get()).tooltip(SCROLL_SLOT_TOOLTIP)));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 35 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 35 + i * 18, 198));
        }
    }

    @Override
    public boolean stillValid(Player playerIn) {
        return SpellcraftingAltarMenu.stillValid((ContainerLevelAccess)this.containerLevelAccess, (Player)playerIn, (Block)((Block)BlocksPM.SPELLCRAFTING_ALTAR.get()));
    }

    public SourceList getManaCosts() {
        return this.getSpellPackage().getManaCost();
    }

    public Player getPlayer() {
        return this.player;
    }

    public SpellPackage getSpellPackage() {
        if (this.spellPackageCache == null) {
            this.spellPackageCache = this.makeFinalSpellPackage();
        }
        return this.spellPackageCache;
    }

    protected SpellPackage makeFinalSpellPackage() {
        return new SpellPackage(this.getSpellName(), this.getSpellVehicleComponent(), this.getSpellPayloadComponent(), this.getSpellPrimaryModComponent(), this.getSpellSecondaryModComponent());
    }

    public String getSpellName() {
        return this.spellName == null || this.spellName.isEmpty() ? this.getDefaultSpellName().getString() : this.spellName;
    }

    @Nonnull
    public Component getDefaultSpellName() {
        Component vehiclePiece = ((AbstractSpellVehicle)this.getSpellVehicleComponent().getComponent()).getDefaultNamePiece();
        Component payloadPiece = ((AbstractSpellPayload)this.getSpellPayloadComponent().getComponent()).getDefaultNamePiece();
        Optional<Component> primaryModPiece = this.getSpellPrimaryModComponent().filter(mod -> ((AbstractSpellMod)mod.getComponent()).isActive()).map(mod -> ((AbstractSpellMod)mod.getComponent()).getDefaultNamePiece());
        Optional<Component> secondaryModPiece = this.getSpellSecondaryModComponent().filter(mod -> ((AbstractSpellMod)mod.getComponent()).isActive()).map(mod -> ((AbstractSpellMod)mod.getComponent()).getDefaultNamePiece());
        boolean primaryActive = primaryModPiece.isPresent();
        boolean secondaryActive = secondaryModPiece.isPresent();
        if (vehiclePiece == null || payloadPiece == null || vehiclePiece.getString().isEmpty() || payloadPiece.getString().isEmpty()) {
            return Component.literal((String)"");
        }
        if (!primaryActive && !secondaryActive) {
            return Component.translatable((String)"spells.primalmagick.default_name_format.mods.0", (Object[])new Object[]{vehiclePiece, payloadPiece});
        }
        if (primaryActive && secondaryActive) {
            return Component.translatable((String)"spells.primalmagick.default_name_format.mods.2", (Object[])new Object[]{vehiclePiece, payloadPiece, primaryModPiece.get(), secondaryModPiece.get()});
        }
        if (primaryActive) {
            return Component.translatable((String)"spells.primalmagick.default_name_format.mods.1", (Object[])new Object[]{vehiclePiece, payloadPiece, primaryModPiece.get()});
        }
        return Component.translatable((String)"spells.primalmagick.default_name_format.mods.1", (Object[])new Object[]{vehiclePiece, payloadPiece, secondaryModPiece.get()});
    }

    public void setSpellName(String name) {
        this.spellName = name;
        this.spellPackageCache = null;
        this.containerLevelAccess.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    @Nonnull
    protected ConfiguredSpellVehicle<?> getSpellVehicleComponent() {
        int index = this.getSpellVehicleTypeIndex();
        List<SpellVehicleType<?>> types = SpellManager.getVehicleTypes(this.player);
        if (index < 0 || index >= types.size()) {
            return new ConfiguredSpellVehicle<EmptySpellVehicle>(EmptySpellVehicle.INSTANCE);
        }
        AbstractSpellVehicle baseVehicle = (AbstractSpellVehicle)types.get(index).instanceSupplier().get();
        HashMap<SpellProperty, Integer> properties = new HashMap<SpellProperty, Integer>();
        this.spellPropertyCache.get((Object)SpellComponent.VEHICLE).forEach((prop, val) -> {
            if (baseVehicle.getProperties().contains(prop)) {
                properties.put((SpellProperty)prop, (Integer)val);
            }
        });
        return new ConfiguredSpellVehicle<AbstractSpellVehicle>(baseVehicle, properties);
    }

    public int getSpellVehicleTypeIndex() {
        return this.spellVehicleTypeIndex;
    }

    public void setSpellVehicleTypeIndex(int index) {
        this.spellVehicleTypeIndex = index = Mth.clamp((int)index, (int)0, (int)(SpellManager.getVehicleTypes(this.player).size() - 1));
        this.spellPackageCache = null;
        this.containerLevelAccess.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected ConfiguredSpellPayload<?> getSpellPayloadComponent() {
        int index = this.getSpellPayloadTypeIndex();
        List<SpellPayloadType<?>> types = SpellManager.getPayloadTypes(this.player);
        if (index < 0 || index >= types.size()) {
            return new ConfiguredSpellPayload<EmptySpellPayload>(EmptySpellPayload.INSTANCE);
        }
        AbstractSpellPayload basePayload = (AbstractSpellPayload)types.get(index).instanceSupplier().get();
        HashMap<SpellProperty, Integer> properties = new HashMap<SpellProperty, Integer>();
        this.spellPropertyCache.get((Object)SpellComponent.PAYLOAD).forEach((prop, val) -> {
            if (basePayload.getProperties().contains(prop)) {
                properties.put((SpellProperty)prop, (Integer)val);
            }
        });
        return new ConfiguredSpellPayload<AbstractSpellPayload>(basePayload, properties);
    }

    public int getSpellPayloadTypeIndex() {
        return this.spellPayloadTypeIndex;
    }

    public void setSpellPayloadTypeIndex(int index) {
        this.spellPayloadTypeIndex = index = Mth.clamp((int)index, (int)0, (int)(SpellManager.getPayloadTypes(this.player).size() - 1));
        this.spellPackageCache = null;
        this.containerLevelAccess.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    private Optional<ConfiguredSpellMod<?>> getSpellModComponentInner(SpellComponent componentType, int index) {
        List<SpellModType<?>> types = SpellManager.getModTypes(this.player);
        if (index < 0 || index >= types.size()) {
            return Optional.empty();
        }
        AbstractSpellMod baseMod = (AbstractSpellMod)types.get(index).instanceSupplier().get();
        HashMap<SpellProperty, Integer> properties = new HashMap<SpellProperty, Integer>();
        this.spellPropertyCache.get((Object)componentType).forEach((prop, val) -> {
            if (baseMod.getProperties().contains(prop)) {
                properties.put((SpellProperty)prop, (Integer)val);
            }
        });
        return Optional.of(new ConfiguredSpellMod<AbstractSpellMod>(baseMod, properties));
    }

    protected Optional<ConfiguredSpellMod<?>> getSpellPrimaryModComponent() {
        return this.getSpellModComponentInner(SpellComponent.PRIMARY_MOD, this.getSpellPrimaryModTypeIndex());
    }

    public int getSpellPrimaryModTypeIndex() {
        return this.spellPrimaryModTypeIndex;
    }

    public void setSpellPrimaryModTypeIndex(int index) {
        this.spellPrimaryModTypeIndex = index = Mth.clamp((int)index, (int)0, (int)(SpellManager.getModTypes(this.player).size() - 1));
        this.spellPackageCache = null;
        this.containerLevelAccess.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected Optional<ConfiguredSpellMod<?>> getSpellSecondaryModComponent() {
        return this.getSpellModComponentInner(SpellComponent.SECONDARY_MOD, this.getSpellSecondaryModTypeIndex());
    }

    public int getSpellSecondaryModTypeIndex() {
        return this.spellSecondaryModTypeIndex;
    }

    public void setSpellSecondaryModTypeIndex(int index) {
        this.spellSecondaryModTypeIndex = index = Mth.clamp((int)index, (int)0, (int)(SpellManager.getModTypes(this.player).size() - 1));
        this.spellPackageCache = null;
        this.containerLevelAccess.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    public void setSpellPropertyValue(SpellComponent component, SpellProperty property, int value) {
        if (component != null && property != null) {
            this.spellPropertyCache.get((Object)component).put(property, value);
            this.spellPackageCache = null;
            this.containerLevelAccess.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
        }
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.clearContainer(playerIn, this.wandInv);
        this.clearContainer(playerIn, (Container)this.scrollInv);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(slotStack, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index >= 3 && index < 30 ? (this.wandSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.scrollSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : !this.moveItemStackTo(slotStack, 30, 39, false))) : (index >= 30 && index < 39 ? (this.wandSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.scrollSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : !this.moveItemStackTo(slotStack, 3, 30, false))) : !this.moveItemStackTo(slotStack, 3, 39, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return stack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.resultInv && super.canTakeItemForPickAll(stack, slotIn);
    }

    public void slotsChanged(Container inventoryIn) {
        super.slotsChanged(inventoryIn);
        this.containerLevelAccess.execute((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected void slotChangedCraftingGrid(Level world) {
        if (!world.isClientSide && this.player instanceof ServerPlayer) {
            SpellcraftingRecipe recipe;
            Recipe recipe2;
            ServerPlayer spe = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.EMPTY;
            Optional opt = world.getServer().getRecipeManager().byKey(RECIPE_LOC);
            if (opt.isPresent() && (recipe2 = ((RecipeHolder)opt.get()).value()) instanceof SpellcraftingRecipe && (recipe = (SpellcraftingRecipe)recipe2).matches(this.scrollInv.asCraftInput(), world) && this.wandContainsEnoughMana((Player)spe) && this.getSpellPackage().isValid() && (stack = recipe.assemble(this.scrollInv.asCraftInput(), (HolderLookup.Provider)world.registryAccess())) != null && stack.getItem() instanceof SpellScrollItem) {
                ((SpellScrollItem)stack.getItem()).setSpell(stack, this.getSpellPackage());
            }
            this.resultInv.setItem(0, stack);
            spe.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, stack));
        }
    }

    protected boolean wandContainsEnoughMana(Player player) {
        Item item;
        ItemStack stack = this.wandInv.getItem(0);
        if (stack == null || stack.isEmpty() || !((item = stack.getItem()) instanceof IWand)) {
            return false;
        }
        IWand wand = (IWand)item;
        return wand.containsMana(stack, player, this.getManaCosts(), (HolderLookup.Provider)player.registryAccess());
    }

    public ItemStack getWand() {
        return this.wandInv.getItem(0);
    }
}

