/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.menus.AbstractScribeTableMenu;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.tiles.devices.ScribeTableTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Vector2i;

public class ScribeTranscribeWorksMenu
extends AbstractScribeTableMenu {
    public static final ResourceLocation BOOK_SLOT_TEXTURE = ResourceUtils.loc("item/empty_book_slot");
    public static final ResourceLocation WRITABLE_BOOK_SLOT_TEXTURE = ResourceUtils.loc("item/empty_writable_book_slot");
    protected static final Component ANCIENT_BOOK_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.scribe_table.slot.ancient_book");
    protected static final Component WRITABLE_BOOK_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.scribe_table.slot.writable_book");
    protected final ResultContainer resultInv = new ResultContainer();
    protected Slot originalSlot;
    protected Slot blankSlot;

    public ScribeTranscribeWorksMenu(int windowId, Inventory inv, BlockPos pos) {
        this(windowId, inv, pos, null);
    }

    public ScribeTranscribeWorksMenu(int windowId, Inventory inv, BlockPos pos, ScribeTableTileEntity entity) {
        super(MenuTypesPM.SCRIBE_TRANSCRIBE_WORKS.get(), windowId, inv, pos, entity);
    }

    @Override
    protected void createModeSlots() {
        this.addSlot(Services.MENU.makeGenericResultSlot(this.player, this.getTileInventory(Direction.DOWN), 0, 124, 63));
        this.originalSlot = this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(Direction.UP), 0, 30, 63, new FilteredSlotProperties().filter(this::isAncientBookStack).background(BOOK_SLOT_TEXTURE).tooltip(ANCIENT_BOOK_TOOLTIP)));
        this.blankSlot = this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(Direction.UP), 1, 66, 63, new FilteredSlotProperties().item(Items.WRITABLE_BOOK).background(WRITABLE_BOOK_SLOT_TEXTURE).tooltip(WRITABLE_BOOK_TOOLTIP)));
    }

    @Override
    protected Vector2i getInventorySlotsOffset() {
        return new Vector2i(0, 56);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (pIndex == 0) {
                if (!this.moveItemStackTo(slotStack, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (pIndex >= 3 && pIndex < 30 ? (this.originalSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.blankSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : !this.moveItemStackTo(slotStack, 30, 39, false))) : (pIndex >= 30 && pIndex < 39 ? (this.originalSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.blankSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : !this.moveItemStackTo(slotStack, 3, 30, false))) : !this.moveItemStackTo(slotStack, 3, 39, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, slotStack);
        }
        return stack;
    }

    public void doTranscribe() {
        ((ScribeTableTileEntity)this.tile).doTranscribe(this.player);
    }
}

