/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.devices.ScribeTableBlock;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.menus.AbstractScribeTableMenu;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.devices.ScribeTableTileEntity;
import com.verdantartifice.primalmagick.common.util.PlayerUtils;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector2i;

public class ScribeStudyVocabularyMenu
extends AbstractScribeTableMenu {
    public static final ResourceLocation BOOK_SLOT_TEXTURE = ResourceUtils.loc("item/empty_book_slot");
    protected static final Component ANCIENT_BOOK_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.scribe_table.slot.ancient_book");
    protected static final int[] COSTS_PER_SLOT = new int[]{25, 100, 300};
    public final int[] costs = new int[3];
    public final int[] levelCostClues = new int[3];
    public final int[] minLevels = new int[]{0, 15, 30};
    private final DataSlot nameSeed = DataSlot.standalone();
    private final DataSlot languageClue = DataSlot.standalone();
    private final DataSlot vocabularyCount = DataSlot.standalone();
    protected Slot studySlot;

    public ScribeStudyVocabularyMenu(int windowId, Inventory inv, BlockPos pos) {
        this(windowId, inv, pos, null);
    }

    public ScribeStudyVocabularyMenu(int windowId, Inventory inv, BlockPos pos, ScribeTableTileEntity entity) {
        super(MenuTypesPM.SCRIBE_STUDY_VOCABULARY.get(), windowId, inv, pos, entity);
        this.addDataSlot(DataSlot.shared((int[])this.costs, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.costs, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.costs, (int)2));
        this.addDataSlot(DataSlot.shared((int[])this.levelCostClues, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.levelCostClues, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.levelCostClues, (int)2));
        this.addDataSlot(DataSlot.shared((int[])this.minLevels, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.minLevels, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.minLevels, (int)2));
        this.addDataSlot(this.nameSeed).set(this.player.getEnchantmentSeed());
        this.addDataSlot(this.languageClue);
        this.addDataSlot(this.vocabularyCount);
        this.refreshBookData();
    }

    @Override
    protected void createModeSlots() {
        this.studySlot = this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(Direction.UP), 0, 15, 75, new FilteredSlotProperties().filter(this::isAncientBookStack).background(BOOK_SLOT_TEXTURE).tooltip(ANCIENT_BOOK_TOOLTIP)));
    }

    @Override
    protected Vector2i getInventorySlotsOffset() {
        return new Vector2i(0, 56);
    }

    @Override
    public void itemsChanged(int itemHandlerIndex, IItemHandlerPM pContainer) {
        super.itemsChanged(itemHandlerIndex, pContainer);
        this.refreshBookData();
    }

    protected void refreshBookData() {
        ItemStack bookStack = this.studySlot.getItem();
        if (bookStack.is(ItemTagsPM.STATIC_BOOKS)) {
            this.getContainerLevelAccess().execute((level, blockPos) -> {
                int linguisticsPower = ScribeTableBlock.getLinguisticsPower(level, blockPos, this.player);
                float costModifier = 1.0f - (float)linguisticsPower / 100.0f;
                Optional<Holder<BookLanguage>> langHolderOpt = StaticBookItem.getBookLanguage(bookStack);
                langHolderOpt.ifPresentOrElse(lang -> {
                    int studyCount = StaticBookItem.getBookDefinition(bookStack).map(h -> LinguisticsManager.getTimesStudied(this.player, (Holder<BookDefinition>)h, (Holder<BookLanguage>)lang)).orElse(0);
                    for (int index = 0; index < 3; ++index) {
                        int baseCost = Math.round((float)COSTS_PER_SLOT[index] * costModifier);
                        this.costs[index] = index >= studyCount ? baseCost + (index > 0 ? Math.max(this.costs[index - 1], 0) : 0) : -1;
                        this.levelCostClues[index] = ScribeStudyVocabularyMenu.getLevelCostClue(this.costs[index], this.player);
                    }
                    this.languageClue.set(lang.getRegisteredName().hashCode());
                    this.vocabularyCount.set(LinguisticsManager.getVocabulary(this.player, (Holder<BookLanguage>)lang));
                }, () -> this.setDefaultBookData());
            });
        } else {
            this.setDefaultBookData();
        }
    }

    private static int getLevelCostClue(int xpCost, Player player) {
        int retVal = 0;
        int currentLevel = player.experienceLevel;
        for (int currentCost = xpCost; currentCost > 0; currentCost -= PlayerUtils.getXpNeededForNextLevel(currentLevel--)) {
            ++retVal;
        }
        return Mth.clamp((int)retVal, (int)0, (int)10);
    }

    protected void setDefaultBookData() {
        for (int index = 0; index < 3; ++index) {
            this.costs[index] = 0;
            this.levelCostClues[index] = 0;
        }
        this.languageClue.set(BookLanguagesPM.DEFAULT.location().toString().hashCode());
        this.vocabularyCount.set(0);
    }

    public boolean checkStudyClick(Player player, int slotId) {
        if (slotId >= 0 && slotId < this.costs.length) {
            ItemStack bookStack = this.studySlot.getItem();
            return this.costs[slotId] > 0 && !bookStack.isEmpty() && (player.experienceLevel >= this.minLevels[slotId] && PlayerUtils.canAffordXp(player, this.costs[slotId]) || player.getAbilities().instabuild);
        }
        LOGGER.error("{} pressed invalid study vocabulary slot index {}", (Object)player.getName().getString(), (Object)slotId);
        return false;
    }

    public void doStudyClick(Player player, int slotId) {
        if (this.checkStudyClick(player, slotId)) {
            this.getContainerLevelAccess().execute((level, blockPos) -> {
                ItemStack bookStack = this.studySlot.getItem();
                Holder bookDef = StaticBookItem.getBookDefinition(bookStack).orElse(null);
                Holder bookLanguage = StaticBookItem.getBookLanguage(bookStack).orElse(null);
                int studyDelta = 0;
                for (int costIndex = 0; costIndex <= slotId && costIndex < this.costs.length; ++costIndex) {
                    if (this.costs[costIndex] <= 0) continue;
                    ++studyDelta;
                }
                if (studyDelta > 0) {
                    player.giveExperiencePoints(-this.costs[slotId]);
                    player.onEnchantmentPerformed(ItemStack.EMPTY, 0);
                    LinguisticsManager.incrementVocabulary(player, (Holder<BookLanguage>)bookLanguage, studyDelta);
                    LinguisticsManager.incrementTimesStudied(player, (Holder<BookDefinition>)bookDef, (Holder<BookLanguage>)bookLanguage, studyDelta);
                    StatsManager.incrementValue(player, StatsPM.VOCABULARY_STUDIED, studyDelta);
                    this.nameSeed.set(player.getEnchantmentSeed());
                    level.playSound(null, blockPos, SoundsPM.WRITING.get(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                    this.refreshBookData();
                }
            });
        }
    }

    public int getNameSeed() {
        return this.nameSeed.get();
    }

    public Holder.Reference<BookLanguage> getBookLanguage() {
        int hashCode = this.languageClue.get();
        return this.level.registryAccess().registryOrThrow(RegistryKeysPM.BOOK_LANGUAGES).holders().filter(h -> h.key().location().toString().hashCode() == hashCode).findFirst().orElse(BookLanguagesPM.getLanguageOrThrow(BookLanguagesPM.DEFAULT, this.level.registryAccess()));
    }

    public int getVocabularyCount() {
        return this.vocabularyCount.get();
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (pIndex == 0) {
                if (!this.moveItemStackTo(slotStack, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (pIndex >= 1 && pIndex < 28 ? (this.studySlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : !this.moveItemStackTo(slotStack, 28, 37, false)) : (pIndex >= 28 && pIndex < 37 ? (this.studySlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : !this.moveItemStackTo(slotStack, 1, 28, false)) : !this.moveItemStackTo(slotStack, 1, 37, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, slotStack);
        }
        return stack;
    }
}

