/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.misc.GrindstoneChangeRecord;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentKey;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentPartialKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.runes.RuneType;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import com.verdantartifice.primalmagick.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;

public class RunicGrindstoneMenu
extends AbstractContainerMenu {
    protected static final List<RuneType> RUNE_TYPES = List.of(RuneType.VERB, RuneType.NOUN, RuneType.SOURCE);
    public final Container resultSlots = new ResultContainer();
    public final Container repairSlots = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            RunicGrindstoneMenu.this.slotsChanged((Container)this);
        }
    };
    protected final ContainerLevelAccess worldPosCallable;
    protected Player player;
    private int xp = -1;

    public RunicGrindstoneMenu(int windowId, Inventory playerInv) {
        this(windowId, playerInv, ContainerLevelAccess.NULL);
    }

    public RunicGrindstoneMenu(int windowId, Inventory playerInv, final ContainerLevelAccess worldPosCallable) {
        super(MenuTypesPM.RUNIC_GRINDSTONE.get(), windowId);
        this.worldPosCallable = worldPosCallable;
        this.player = playerInv.player;
        this.addSlot(RunicGrindstoneMenu.makeInputSlot(this.repairSlots, 0, 49, 19));
        this.addSlot(RunicGrindstoneMenu.makeInputSlot(this.repairSlots, 1, 49, 40));
        this.addSlot(new Slot(this.resultSlots, 2, 129, 34){

            public boolean mayPlace(ItemStack pStack) {
                return false;
            }

            public void onTake(Player pPlayer, ItemStack pStack) {
                worldPosCallable.execute((level, pos) -> {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)Vec3.atCenterOf((Vec3i)pos), (int)this.getExperienceAmount((Level)level));
                        ItemStack topStack = RunicGrindstoneMenu.this.repairSlots.getItem(0).copy();
                        ItemStack bottomStack = RunicGrindstoneMenu.this.repairSlots.getItem(1).copy();
                        RunicGrindstoneMenu.this.mergeEnchants(topStack, bottomStack);
                        RunicGrindstoneMenu.this.grantHints(topStack, bottomStack);
                    }
                    level.levelEvent(1042, pos, 0);
                });
                RunicGrindstoneMenu.this.repairSlots.setItem(0, ItemStack.EMPTY);
                RunicGrindstoneMenu.this.repairSlots.setItem(1, ItemStack.EMPTY);
            }

            private int getExperienceAmount(Level level) {
                if (RunicGrindstoneMenu.this.xp > -1) {
                    return RunicGrindstoneMenu.this.xp;
                }
                int l = 0;
                l += this.getExperienceFromItem(RunicGrindstoneMenu.this.repairSlots.getItem(0));
                if ((l += this.getExperienceFromItem(RunicGrindstoneMenu.this.repairSlots.getItem(1))) > 0) {
                    int i1 = (int)Math.ceil((double)l / 2.0);
                    return i1 + level.random.nextInt(i1);
                }
                return 0;
            }

            private int getExperienceFromItem(ItemStack stack) {
                int total = 0;
                for (Object2IntMap.Entry entry : EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet()) {
                    Holder enchHolder = (Holder)entry.getKey();
                    int val = entry.getIntValue();
                    if (enchHolder.is(EnchantmentTags.CURSE)) continue;
                    total += ((Enchantment)enchHolder.value()).getMinCost(val);
                }
                return total;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
    }

    protected static Slot makeInputSlot(Container pContainer, int pSlot, int pX, int pY) {
        return Services.MENU.makeFilteredSlot(Services.ITEM_HANDLERS.wrap(pContainer, null), pSlot, pX, pY, new FilteredSlotProperties().filter(stack -> stack.isDamageableItem() || stack.is(Items.ENCHANTED_BOOK) || stack.isEnchanted() || Services.ITEM_STACKS.canGrindstoneRepair((ItemStack)stack) || RuneManager.hasRunes(stack)));
    }

    public void slotsChanged(Container pContainer) {
        super.slotsChanged(pContainer);
        if (pContainer == this.repairSlots) {
            this.createResult();
        }
    }

    public ItemStack removeNonCurses(ItemStack pItem) {
        ItemEnchantments enchantments = EnchantmentHelper.updateEnchantments((ItemStack)pItem, updater -> updater.removeIf(enchHolder -> !enchHolder.is(EnchantmentTags.CURSE)));
        if (pItem.is(Items.ENCHANTED_BOOK) && enchantments.isEmpty()) {
            pItem = pItem.transmuteCopy((ItemLike)Items.BOOK);
        }
        int cost = 0;
        for (int index = 0; index < enchantments.size(); ++index) {
            cost = AnvilMenu.calculateIncreasedRepairCost((int)cost);
        }
        pItem.set(DataComponents.REPAIR_COST, (Object)cost);
        RuneManager.clearRunes(pItem);
        return pItem;
    }

    public void createResult() {
        GrindstoneChangeRecord change = Services.EVENTS.onGrindstoneChange(this.repairSlots.getItem(0), this.repairSlots.getItem(1), this.resultSlots, -1);
        this.resultSlots.setItem(0, this.computeResult(this.repairSlots.getItem(0), this.repairSlots.getItem(1), change));
        this.broadcastChanges();
    }

    private ItemStack computeResult(ItemStack pInputItem, ItemStack pAdditionalItem, GrindstoneChangeRecord change) {
        boolean flag;
        if (change.xp() != Integer.MIN_VALUE) {
            if (change.canceled()) {
                this.xp = -1;
                return ItemStack.EMPTY;
            }
            if (!change.output().isEmpty()) {
                this.xp = change.xp();
                return change.output();
            }
        } else {
            this.xp = change.xp();
        }
        boolean bl = flag = !pInputItem.isEmpty() || !pAdditionalItem.isEmpty();
        if (!flag) {
            return ItemStack.EMPTY;
        }
        if (pInputItem.getCount() <= 1 && pAdditionalItem.getCount() <= 1) {
            boolean flag1;
            boolean bl2 = flag1 = !pInputItem.isEmpty() && !pAdditionalItem.isEmpty();
            if (!flag1) {
                ItemStack itemstack = !pInputItem.isEmpty() ? pInputItem : pAdditionalItem;
                return !EnchantmentHelper.hasAnyEnchantments((ItemStack)itemstack) ? ItemStack.EMPTY : this.removeNonCurses(itemstack.copy());
            }
            return this.mergeItems(pInputItem, pAdditionalItem);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack mergeItems(ItemStack pInputItem, ItemStack pAdditionalItem) {
        ItemStack itemstack;
        if (!pInputItem.is(pAdditionalItem.getItem())) {
            return ItemStack.EMPTY;
        }
        int i = Math.max(pInputItem.getMaxDamage(), pAdditionalItem.getMaxDamage());
        int j = pInputItem.getMaxDamage() - pInputItem.getDamageValue();
        int k = pAdditionalItem.getMaxDamage() - pAdditionalItem.getDamageValue();
        int l = j + k + i * 5 / 100;
        int i1 = 1;
        if (!pInputItem.isDamageableItem()) {
            if (pInputItem.getMaxStackSize() < 2 || !ItemStack.matches((ItemStack)pInputItem, (ItemStack)pAdditionalItem)) {
                return ItemStack.EMPTY;
            }
            i1 = 2;
        }
        if ((itemstack = pInputItem.copyWithCount(i1)).isDamageableItem()) {
            itemstack.set(DataComponents.MAX_DAMAGE, (Object)i);
            itemstack.setDamageValue(Math.max(i - l, 0));
        }
        this.mergeEnchants(itemstack, pAdditionalItem);
        return this.removeNonCurses(itemstack);
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.worldPosCallable.execute((level, pos) -> this.clearContainer(pPlayer, this.repairSlots));
    }

    public boolean stillValid(Player playerIn) {
        return RunicGrindstoneMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)((Block)BlocksPM.RUNIC_GRINDSTONE.get()));
    }

    protected void grantHints(ItemStack stack, ItemStack otherStack) {
        Set enchants = stack.isEmpty() ? otherStack.getEnchantments().keySet() : stack.getEnchantments().keySet();
        this.worldPosCallable.execute((level, pos) -> {
            MutableInt hintCount = new MutableInt(0);
            for (Holder enchant : enchants) {
                RuneManager.getRuneDefinition(level.registryAccess(), (Holder<Enchantment>)enchant).ifPresent(definition -> {
                    List<RuneEnchantmentPartialKey> candidates;
                    Optional<AbstractRequirement<?>> requirementOpt;
                    RuneEnchantmentKey fullResearch = new RuneEnchantmentKey((Holder<Enchantment>)enchant);
                    if (!fullResearch.isKnownBy(this.player) && ((requirementOpt = definition.requirementOpt()).isEmpty() || requirementOpt.get().isMetBy(this.player)) && !(candidates = definition.getRunes().stream().filter(rune -> rune.getRequirement().isMetBy(this.player)).map(rune -> new RuneEnchantmentPartialKey((Holder<Enchantment>)enchant, rune.getType())).filter(key -> !key.isKnownBy(this.player)).toList()).isEmpty()) {
                        WeightedRandomBag<RuneEnchantmentPartialKey> candidateBag = new WeightedRandomBag<RuneEnchantmentPartialKey>();
                        for (RuneEnchantmentPartialKey candidate : candidates) {
                            candidateBag.add(candidate, 1.0);
                        }
                        ResearchManager.completeResearch(this.player, ResearchEntries.UNLOCK_RUNE_ENCHANTMENTS);
                        ResearchManager.completeResearch(this.player, (AbstractResearchKey)candidateBag.getRandom(this.player.getRandom()));
                        hintCount.increment();
                        if (definition.getRunes().stream().map(rune -> new RuneEnchantmentPartialKey((Holder<Enchantment>)enchant, rune.getType())).allMatch(key -> key.isKnownBy(this.player))) {
                            ResearchManager.completeResearch(this.player, fullResearch);
                        }
                    }
                });
            }
            if (hintCount.intValue() > 0) {
                this.player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.runic_grindstone.hints_granted").withStyle(ChatFormatting.GREEN), false);
            }
        });
    }

    public void mergeEnchants(ItemStack pCopyTo, ItemStack pCopyFrom) {
        EnchantmentHelper.updateEnchantments((ItemStack)pCopyTo, updater -> {
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)pCopyFrom);
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (holder.is(EnchantmentTags.CURSE) && updater.getLevel(holder) != 0) continue;
                updater.upgrade(holder, entry.getIntValue());
            }
        });
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            ItemStack itemstack2 = this.repairSlots.getItem(0);
            ItemStack itemstack3 = this.repairSlots.getItem(1);
            if (pIndex == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (pIndex != 0 && pIndex != 1 ? (!itemstack2.isEmpty() && !itemstack3.isEmpty() ? (pIndex >= 3 && pIndex < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : pIndex >= 30 && pIndex < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 0, 2, false)) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }
}

