/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.crafting.inputs.RunecarvingRecipeInput;
import com.verdantartifice.primalmagick.common.items.IItemHandlerChangeListener;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.crafting.RunecarvingTableTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class RunecarvingTableMenu
extends AbstractTileSidedInventoryMenu<RunecarvingTableTileEntity>
implements IItemHandlerChangeListener {
    public static final ResourceLocation BASE_SLOT_TEXTURE = ResourceUtils.loc("item/empty_slab_slot");
    public static final ResourceLocation ETCHING_SLOT_TEXTURE = ResourceUtils.loc("item/empty_lapis_slot");
    protected static final Component BASE_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.runecarving_table.slot.base");
    protected static final Component ETCHING_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.runecarving_table.slot.etching");
    protected final DataSlot selectedRecipe = DataSlot.standalone();
    protected final Player player;
    protected final Slot inputSlabSlot;
    protected final Slot inputLapisSlot;
    protected final Slot outputSlot;
    protected final ResultContainer outputInventory = new ResultContainer();
    protected List<RecipeHolder<IRunecarvingRecipe>> recipes = new ArrayList<RecipeHolder<IRunecarvingRecipe>>();
    protected ItemStack slabInput = ItemStack.EMPTY;
    protected ItemStack lapisInput = ItemStack.EMPTY;
    protected long lastOnTake;
    protected Runnable inventoryUpdateListener = () -> {};

    public RunecarvingTableMenu(int windowId, Inventory inv, BlockPos pos) {
        this(windowId, inv, pos, null);
    }

    public RunecarvingTableMenu(int windowId, Inventory inv, BlockPos pos, RunecarvingTableTileEntity table) {
        super(MenuTypesPM.RUNECARVING_TABLE.get(), windowId, RunecarvingTableTileEntity.class, inv.player.level(), pos, table);
        int i;
        this.player = inv.player;
        ((RunecarvingTableTileEntity)this.tile).addInventoryChangeListener(Direction.UP, this);
        this.inputSlabSlot = this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(0), 0, 20, 21, new FilteredSlotProperties().background(BASE_SLOT_TEXTURE).tooltip(BASE_SLOT_TOOLTIP).tag(ItemTagsPM.RUNE_BASES)));
        this.inputLapisSlot = this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(0), 1, 20, 46, new FilteredSlotProperties().background(ETCHING_SLOT_TEXTURE).tooltip(ETCHING_SLOT_TOOLTIP).tag(ItemTagsPM.RUNE_ETCHINGS)));
        this.outputSlot = this.addSlot(Services.MENU.makeRunecarvingResultSlot(this, this.player, Services.ITEM_HANDLERS.wrap((Container)this.outputInventory, null), 0, 143, 33));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
        this.addDataSlot(this.selectedRecipe);
        this.itemsChanged(0, this.getTileInventory(0));
    }

    public RecipeCraftingHolder getOutputInventory() {
        return this.outputInventory;
    }

    public long getLastOnTake() {
        return this.lastOnTake;
    }

    public void setLastOnTake(long lastOnTake) {
        this.lastOnTake = lastOnTake;
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.get();
    }

    public List<RecipeHolder<IRunecarvingRecipe>> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputSlabSlot.hasItem() && this.inputLapisSlot.hasItem() && !this.recipes.isEmpty();
    }

    public boolean clickMenuButton(Player playerIn, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectedRecipe.set(id);
            this.outputInventory.setRecipeUsed(this.recipes.get(id));
            this.updateRecipeResultSlot(playerIn.level().registryAccess());
        }
        return true;
    }

    @Override
    public void itemsChanged(int itemHandlerIndex, IItemHandlerPM itemHandler) {
        ItemStack slabStack = this.inputSlabSlot.getItem();
        ItemStack lapisStack = this.inputLapisSlot.getItem();
        if (slabStack.getItem() != this.slabInput.getItem() || lapisStack.getItem() != this.lapisInput.getItem()) {
            this.slabInput = slabStack.copy();
            this.lapisInput = lapisStack.copy();
            this.updateAvailableRecipes(itemHandler, slabStack, lapisStack);
        }
        this.inventoryUpdateListener.run();
    }

    private static RunecarvingRecipeInput createRecipeInput(IItemHandlerPM inventory) {
        return new RunecarvingRecipeInput(inventory.getStackInSlot(0), inventory.getStackInSlot(1));
    }

    protected void updateAvailableRecipes(IItemHandlerPM inventoryIn, ItemStack slabStack, ItemStack lapisStack) {
        this.recipes.clear();
        this.selectedRecipe.set(-1);
        this.outputSlot.set(ItemStack.EMPTY);
        this.recipes = this.level.getRecipeManager().getRecipesFor(RecipeTypesPM.RUNECARVING.get(), (RecipeInput)RunecarvingTableMenu.createRecipeInput(inventoryIn), this.level).stream().filter(r -> r != null && (((IRunecarvingRecipe)r.value()).getRequirement().isEmpty() || ((AbstractRequirement)((IRunecarvingRecipe)r.value()).getRequirement().get()).isMetBy(this.player))).collect(Collectors.toList());
    }

    public void updateRecipeResultSlot(RegistryAccess registryAccess) {
        if (!this.recipes.isEmpty() && this.getTileInventory(Direction.UP) != null) {
            IRunecarvingRecipe recipe = (IRunecarvingRecipe)this.recipes.get(this.selectedRecipe.get()).value();
            this.outputSlot.set(recipe.assemble(RunecarvingTableMenu.createRecipeInput(this.getTileInventory(Direction.UP)), (HolderLookup.Provider)registryAccess));
        } else {
            this.outputSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn != this.outputSlot && super.canTakeItemForPickAll(stack, slotIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 2) {
                slotStack.getItem().onCraftedBy(slotStack, playerIn.level(), playerIn);
                if (!this.moveItemStackTo(slotStack, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index == 0 || index == 1 ? !this.moveItemStackTo(slotStack, 3, 39, false) : (this.inputSlabSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : (this.inputLapisSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (index >= 3 && index < 30 ? !this.moveItemStackTo(slotStack, 30, 39, false) : index >= 30 && index < 39 && !this.moveItemStackTo(slotStack, 3, 30, false))))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
            this.broadcastChanges();
        }
        return stack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.outputInventory.removeItemNoUpdate(0);
    }
}

