/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.tiles.devices.HoneyExtractorTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HoneyExtractorMenu
extends AbstractTileSidedInventoryMenu<HoneyExtractorTileEntity> {
    public static final ResourceLocation BOTTLE_SLOT_TEXTURE = ResourceUtils.loc("item/empty_bottle_slot");
    public static final ResourceLocation HONEYCOMB_SLOT_TEXTURE = ResourceUtils.loc("item/empty_honeycomb_slot");
    protected static final Component BOTTLE_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.honey_extractor.slot.bottle");
    protected static final Component HONEYCOMB_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.honey_extractor.slot.honeycomb");
    protected final ContainerData extractorData;
    protected final Slot honeycombSlot;
    protected final Slot bottleSlot;
    protected final Slot wandSlot;

    public HoneyExtractorMenu(int id, Inventory playerInv, BlockPos tilePos) {
        this(id, playerInv, tilePos, null, (ContainerData)new SimpleContainerData(4));
    }

    public HoneyExtractorMenu(int id, Inventory playerInv, BlockPos tilePos, HoneyExtractorTileEntity extractor, ContainerData extractorData) {
        super(MenuTypesPM.HONEY_EXTRACTOR.get(), id, HoneyExtractorTileEntity.class, playerInv.player.level(), tilePos, extractor);
        HoneyExtractorMenu.checkContainerDataCount((ContainerData)extractorData, (int)4);
        this.extractorData = extractorData;
        this.honeycombSlot = this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(0), 0, 30, 35, new FilteredSlotProperties().background(HONEYCOMB_SLOT_TEXTURE).tooltip(HONEYCOMB_SLOT_TOOLTIP).item(Items.HONEYCOMB)));
        this.bottleSlot = this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(0), 1, 52, 35, new FilteredSlotProperties().background(BOTTLE_SLOT_TEXTURE).tooltip(BOTTLE_SLOT_TOOLTIP).item(Items.GLASS_BOTTLE)));
        this.addSlot(Services.MENU.makeGenericResultSlot(playerInv.player, this.getTileInventory(1), 0, 108, 35));
        this.addSlot(Services.MENU.makeGenericResultSlot(playerInv.player, this.getTileInventory(1), 1, 130, 35));
        this.wandSlot = this.addSlot(Services.MENU.makeWandSlot(this.getTileInventory(2), 0, 8, 62, false));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
        this.addDataSlots(this.extractorData);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 2 || index == 3) {
                if (!this.moveItemStackTo(slotStack, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index == 0 || index == 1 || index == 4 ? !this.moveItemStackTo(slotStack, 5, 41, false) : (this.honeycombSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : (this.bottleSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) : (this.wandSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 4, 5, false) : (index >= 5 && index < 32 ? !this.moveItemStackTo(slotStack, 32, 41, false) : index >= 32 && index < 41 && !this.moveItemStackTo(slotStack, 5, 32, false)))))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
            this.broadcastChanges();
        }
        return stack;
    }

    public int getSpinProgressionScaled() {
        int i = this.extractorData.get(0);
        int j = this.extractorData.get(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getCurrentMana() {
        return this.extractorData.get(2);
    }

    public int getMaxMana() {
        return this.extractorData.get(3);
    }
}

