/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.items.IItemHandlerChangeListener;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.ResearchRequirement;
import com.verdantartifice.primalmagick.common.tiles.devices.DesalinatorTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.slf4j.Logger;

public class DesalinatorMenu
extends AbstractTileSidedInventoryMenu<DesalinatorTileEntity>
implements IItemHandlerChangeListener {
    public static final ResourceLocation BUCKET_SLOT_TEXTURE = ResourceUtils.loc("item/empty_bucket_slot");
    public static final ResourceLocation BOTTLE_SLOT_TEXTURE = ResourceUtils.loc("item/empty_bottle_slot");
    public static final ResourceLocation FLASK_SLOT_TEXTURE = ResourceUtils.loc("item/empty_flask_slot");
    protected static final Component WATER_BUCKET_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.desalinator.slot.water_bucket");
    protected static final AbstractRequirement<?> FLASK_REQUIREMENT = new ResearchRequirement(new ResearchEntryKey(ResearchEntries.CONCOCTING_TINCTURES));
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected final Player player;
    protected final ContainerData containerData;
    protected final Slot waterBucketSlot;
    protected final Slot wandSlot;
    protected ItemStack lastInputStack = ItemStack.EMPTY;

    public DesalinatorMenu(int id, Inventory playerInv, BlockPos tilePos) {
        this(id, playerInv, tilePos, null, (ContainerData)new SimpleContainerData(6));
    }

    public DesalinatorMenu(int id, Inventory playerInv, BlockPos tilePos, DesalinatorTileEntity desalinator, ContainerData containerData) {
        super(MenuTypesPM.DESALINATOR.get(), id, DesalinatorTileEntity.class, playerInv.player.level(), tilePos, desalinator);
        DesalinatorMenu.checkContainerDataCount((ContainerData)containerData, (int)6);
        this.containerData = containerData;
        this.player = playerInv.player;
        ((DesalinatorTileEntity)this.tile).addInventoryChangeListener(Direction.UP, this);
        this.waterBucketSlot = this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(0), 0, 30, 17, new FilteredSlotProperties().filter(DesalinatorTileEntity::isFullWaterContainer).tooltip(WATER_BUCKET_TOOLTIP).background(BUCKET_SLOT_TEXTURE).background(BOTTLE_SLOT_TEXTURE).background(FLASK_SLOT_TEXTURE, $ -> FLASK_REQUIREMENT.isMetBy(this.player))));
        this.addSlot(Services.MENU.makeGenericResultSlot(playerInv.player, this.getTileInventory(1), 0, 108, 45));
        this.addSlot(Services.MENU.makeGenericResultSlot(playerInv.player, this.getTileInventory(1), 1, 130, 45));
        this.addSlot(Services.MENU.makeGenericResultSlot(playerInv.player, this.getTileInventory(1), 2, 30, 72));
        this.wandSlot = this.addSlot(Services.MENU.makeWandSlot(this.getTileInventory(2), 0, 8, 72, false));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 103 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInv, k, 8 + k * 18, 161));
        }
        this.addDataSlots(this.containerData);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 1 || index == 2 || index == 3) {
                if (!this.moveItemStackTo(slotStack, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index == 0 || index == 4 ? !this.moveItemStackTo(slotStack, 5, 41, false) : (this.waterBucketSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : (this.wandSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 4, 5, false) : (index >= 5 && index < 32 ? !this.moveItemStackTo(slotStack, 32, 41, false) : index >= 32 && index < 41 && !this.moveItemStackTo(slotStack, 5, 32, false))))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
            this.broadcastChanges();
        }
        return stack;
    }

    public int getBoilProgressionScaled() {
        int i = this.containerData.get(0);
        int j = this.containerData.get(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getCurrentMana() {
        return this.containerData.get(2);
    }

    public int getMaxMana() {
        return this.containerData.get(3);
    }

    public int getCurrentWaterAmount() {
        return this.containerData.get(4);
    }

    public int getWaterCapacity() {
        return this.containerData.get(5);
    }

    @Override
    public void itemsChanged(int itemHandlerIndex, IItemHandlerPM itemHandler) {
        if (itemHandlerIndex == 0) {
            ItemStack stack = itemHandler.getStackInSlot(0);
            if (stack.isEmpty() && !this.lastInputStack.isEmpty()) {
                this.player.playSound(this.lastInputStack.is(Items.WATER_BUCKET) ? SoundEvents.BUCKET_EMPTY : SoundEvents.BOTTLE_EMPTY, 1.0f, 1.0f);
            }
            this.lastInputStack = stack.copy();
        }
    }
}

