/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.tiles.crafting.AbstractCalcinatorTileEntity;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CalcinatorMenu
extends AbstractTileSidedInventoryMenu<AbstractCalcinatorTileEntity> {
    protected static final Component INPUT_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.calcinator.slot.input");
    protected final ContainerData calcinatorData;

    public CalcinatorMenu(int id, Inventory playerInv, BlockPos tilePos) {
        this(id, playerInv, tilePos, null, (ContainerData)new SimpleContainerData(4));
    }

    public CalcinatorMenu(int id, Inventory playerInv, BlockPos tilePos, AbstractCalcinatorTileEntity calcinator, ContainerData calcinatorData) {
        super(MenuTypesPM.CALCINATOR.get(), id, AbstractCalcinatorTileEntity.class, playerInv.player.level(), tilePos, calcinator);
        int i;
        CalcinatorMenu.checkContainerDataCount((ContainerData)calcinatorData, (int)4);
        this.calcinatorData = calcinatorData;
        this.addSlot(Services.MENU.makeFilteredSlot(this.getTileInventory(Direction.UP), 0, 34, 17, new FilteredSlotProperties().tooltip(INPUT_SLOT_TOOLTIP)));
        this.addSlot(Services.MENU.makeCalcinatorFuelSlot(this, this.getTileInventory(Direction.NORTH), 0, 34, 53));
        for (i = 0; i < 9; ++i) {
            this.addSlot(Services.MENU.makeCalcinatorResultSlot(playerInv.player, this.getTileInventory(Direction.DOWN), i, 90 + i % 3 * 18, 17 + i / 3 * 18));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
        this.addDataSlots(this.calcinatorData);
    }

    @Override
    public boolean stillValid(Player playerIn) {
        return this.tile == null ? false : ((AbstractCalcinatorTileEntity)this.tile).stillValid(playerIn);
    }

    public boolean isFuel(ItemStack stack) {
        return AbstractCalcinatorTileEntity.isFuel(stack);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index >= 2 && index < 11) {
                if (!this.moveItemStackTo(slotStack, 11, 47, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index != 0 && index != 1 ? (this.isFuel(slotStack) ? !this.moveItemStackTo(slotStack, 1, 2, false) && !this.moveItemStackTo(slotStack, 0, 1, false) : !this.moveItemStackTo(slotStack, 0, 1, false)) : !this.moveItemStackTo(slotStack, 11, 47, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return stack;
    }

    public int getCookProgressionScaled() {
        int i = this.calcinatorData.get(2);
        int j = this.calcinatorData.get(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getBurnLeftScaled() {
        int total = this.calcinatorData.get(1);
        if (total == 0) {
            total = 200;
        }
        return this.calcinatorData.get(0) * 13 / total;
    }

    public boolean isBurning() {
        return this.calcinatorData.get(0) > 0;
    }
}

