/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.crafting.WandInventory;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookType;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import com.verdantartifice.primalmagick.common.menus.slots.ArcaneCraftingResultSlot;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ArcaneWorkbenchMenu
extends AbstractContainerMenu
implements IArcaneRecipeBookMenu<CraftingInput, CraftingRecipe> {
    protected final CraftingContainer craftingInv = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    protected final WandInventory wandInv = new WandInventory(this);
    protected final ResultContainer resultInv = new ResultContainer();
    protected final ContainerLevelAccess worldPosCallable;
    protected final Player player;
    protected final Slot wandSlot;
    protected RecipeHolder<IArcaneRecipe> activeArcaneRecipe = null;

    public ArcaneWorkbenchMenu(int windowId, Inventory inv) {
        this(windowId, inv, ContainerLevelAccess.NULL);
    }

    public ArcaneWorkbenchMenu(int windowId, Inventory inv, ContainerLevelAccess callable) {
        super(MenuTypesPM.ARCANE_WORKBENCH.get(), windowId);
        int j;
        int i;
        this.worldPosCallable = callable;
        this.player = inv.player;
        this.addSlot(new ArcaneCraftingResultSlot(this.player, this.craftingInv, this.wandInv, (Container)this.resultInv, 0, 138, 52));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.craftingInv, j + i * 3, 44 + j * 18, 34 + i * 18));
            }
        }
        this.wandSlot = this.addSlot(Services.MENU.makeWandSlot(Services.ITEM_HANDLERS.wrap(this.wandInv, null), 0, 19, 52, false));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 101 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 159));
        }
    }

    @Nullable
    public RecipeHolder<IArcaneRecipe> getActiveArcaneRecipe() {
        return this.activeArcaneRecipe;
    }

    public boolean stillValid(Player playerIn) {
        return ArcaneWorkbenchMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)BlocksPM.ARCANE_WORKBENCH.get());
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.clearContainer(playerIn, this.wandInv);
        this.clearContainer(playerIn, (Container)this.craftingInv);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(slotStack, 11, 47, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index >= 11 && index < 38 ? (this.wandSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 10, 11, false) : !this.moveItemStackTo(slotStack, 1, 10, false) && !this.moveItemStackTo(slotStack, 38, 47, false)) : (index >= 38 && index < 47 ? (this.wandSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 10, 11, false) : !this.moveItemStackTo(slotStack, 1, 10, false) && !this.moveItemStackTo(slotStack, 11, 38, false)) : !this.moveItemStackTo(slotStack, 11, 47, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return stack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.resultInv && super.canTakeItemForPickAll(stack, slotIn);
    }

    public void slotsChanged(Container inventoryIn) {
        super.slotsChanged(inventoryIn);
        this.slotChangedCraftingGrid(this.player.level());
    }

    protected void slotChangedCraftingGrid(Level world) {
        CraftingInput craftInput = this.craftingInv.asCraftInput();
        if (world.isClientSide) {
            RecipeHolder recipe;
            this.activeArcaneRecipe = null;
            Optional arcaneOptional = world.getRecipeManager().getRecipeFor(RecipeTypesPM.ARCANE_CRAFTING.get(), (RecipeInput)craftInput, world);
            if (arcaneOptional.isPresent() && (((IArcaneRecipe)(recipe = (RecipeHolder)arcaneOptional.get()).value()).getRequirement().isEmpty() || ((AbstractRequirement)((IArcaneRecipe)recipe.value()).getRequirement().get()).isMetBy(this.player))) {
                this.activeArcaneRecipe = recipe;
            }
        }
        if (!world.isClientSide && this.player instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.EMPTY;
            Optional arcaneOptional = world.getServer().getRecipeManager().getRecipeFor(RecipeTypesPM.ARCANE_CRAFTING.get(), (RecipeInput)craftInput, world);
            if (arcaneOptional.isPresent()) {
                RecipeHolder recipe = (RecipeHolder)arcaneOptional.get();
                if (this.canUseArcaneRecipe(world, spe, (RecipeHolder<IArcaneRecipe>)recipe)) {
                    stack = ((IArcaneRecipe)recipe.value()).assemble((RecipeInput)craftInput, (HolderLookup.Provider)world.registryAccess());
                }
            } else {
                RecipeHolder recipe;
                Optional vanillaOptional = world.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftInput, world);
                if (vanillaOptional.isPresent() && this.resultInv.setRecipeUsed(world, spe, recipe = (RecipeHolder)vanillaOptional.get())) {
                    stack = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)craftInput, (HolderLookup.Provider)world.registryAccess());
                }
            }
            this.resultInv.setItem(0, stack);
            spe.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, stack));
        }
    }

    protected boolean canUseArcaneRecipe(Level world, ServerPlayer player, RecipeHolder<IArcaneRecipe> recipeHolder) {
        IArcaneRecipe recipe = (IArcaneRecipe)recipeHolder.value();
        return !(!this.resultInv.setRecipeUsed(world, player, recipeHolder) || !recipe.getRequirement().isEmpty() && !((AbstractRequirement)recipe.getRequirement().get()).isMetBy((Player)player) || !recipe.getManaCosts().isEmpty() && !this.wandContainsEnoughMana((Player)player, recipe));
    }

    protected boolean wandContainsEnoughMana(Player player, IArcaneRecipe recipe) {
        Item item;
        ItemStack stack = this.getWand();
        if (stack == null || stack.isEmpty() || !((item = stack.getItem()) instanceof IWand)) {
            return false;
        }
        IWand wand = (IWand)item;
        return wand.containsMana(stack, player, recipe.getManaCosts(), (HolderLookup.Provider)player.registryAccess());
    }

    @Override
    public void fillCraftSlotsStackedContents(StackedContents contents) {
        this.craftingInv.fillStackedContents(contents);
    }

    @Override
    public void clearCraftingContent() {
        this.craftingInv.clearContent();
        this.resultInv.clearContent();
    }

    @Override
    public boolean recipeMatches(RecipeHolder<CraftingRecipe> recipe) {
        return ((CraftingRecipe)recipe.value()).matches((RecipeInput)this.craftingInv.asCraftInput(), this.player.level());
    }

    @Override
    public int getResultSlotIndex() {
        return 0;
    }

    @Override
    public int getGridWidth() {
        return this.craftingInv.getWidth();
    }

    @Override
    public int getGridHeight() {
        return this.craftingInv.getHeight();
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public ArcaneRecipeBookType getRecipeBookType() {
        return ArcaneRecipeBookType.CRAFTING;
    }

    @Override
    public boolean shouldMoveToInventory(int index) {
        return index != this.getResultSlotIndex();
    }

    @Override
    public NonNullList<Slot> getSlots() {
        return this.slots;
    }

    public ItemStack getWand() {
        return this.wandInv.getItem(0);
    }

    public Player getPlayer() {
        return this.player;
    }
}

