/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.slots.AnalysisResultSlot;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisTableMenu
extends AbstractContainerMenu {
    protected static final Component INPUT_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.analysis_table.slot.input");
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Container analysisInventory = new SimpleContainer(this, 2){

        public int getMaxStackSize() {
            return 1;
        }
    };
    protected final ContainerLevelAccess worldPosCallable;
    protected final Player player;

    public AnalysisTableMenu(int windowId, Inventory inv) {
        this(windowId, inv, ContainerLevelAccess.NULL);
    }

    public AnalysisTableMenu(int windowId, Inventory inv, ContainerLevelAccess callable) {
        super(MenuTypesPM.ANALYSIS_TABLE.get(), windowId);
        int i;
        this.worldPosCallable = callable;
        this.player = inv.player;
        this.addSlot(Services.MENU.makeFilteredSlot(Services.ITEM_HANDLERS.wrap(this.analysisInventory, null), 0, 56, 35, new FilteredSlotProperties().tooltip(INPUT_SLOT_TOOLTIP)));
        this.addSlot(new AnalysisResultSlot(this.analysisInventory, 1, 103, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
    }

    public boolean stillValid(Player playerIn) {
        return AnalysisTableMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)BlocksPM.ANALYSIS_TABLE.get());
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 0 ? !this.moveItemStackTo(slotStack, 2, 38, true) : (index >= 2 && index < 29 ? !this.moveItemStackTo(slotStack, 0, 1, false) : index >= 29 && index < 38 && !this.moveItemStackTo(slotStack, 0, 1, false))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
        }
        return stack;
    }

    public ItemStack getLastScannedStack() {
        return this.analysisInventory.getItem(1);
    }

    public void doScan() {
        Player player;
        Level level = this.player.level();
        if (!level.isClientSide && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = this.analysisInventory.getItem(0).copy();
            if (stack.is(ItemTagsPM.ANALYSIS_TABLE_FORBIDDEN)) {
                this.player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.analysis_table.forbidden").withStyle(ChatFormatting.RED), false);
            } else if (!stack.isEmpty()) {
                this.analysisInventory.setItem(0, ItemStack.EMPTY);
                this.analysisInventory.setItem(1, stack);
                ((CompletableFuture)ResearchManager.isScannedAsync(stack, (Player)serverPlayer).thenAccept(isScanned -> {
                    if (!isScanned.booleanValue()) {
                        ResearchManager.setScanned(stack, serverPlayer);
                    }
                })).exceptionally(e -> {
                    LOGGER.error("Failed to analyze item stack at analysis table: " + stack.toString(), e);
                    return null;
                });
            }
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.analysisInventory.setItem(1, ItemStack.EMPTY);
        this.clearContainer(player, this.analysisInventory);
    }
}

