/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.capabilities.IItemHandlerPM;
import com.verdantartifice.primalmagick.common.items.IItemHandlerChangeListener;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.data.ContainerSynchronizerLarge;
import com.verdantartifice.primalmagick.common.tags.BookLanguageTagsPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.devices.ScribeTableTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector2i;

public abstract class AbstractScribeTableMenu
extends AbstractTileSidedInventoryMenu<ScribeTableTileEntity>
implements IItemHandlerChangeListener {
    protected final Player player;
    protected final Level level;

    public AbstractScribeTableMenu(@Nonnull MenuType<?> type, int id, @Nonnull Inventory playerInv, BlockPos tilePos, ScribeTableTileEntity entity) {
        super(type, id, ScribeTableTileEntity.class, playerInv.player.level(), tilePos, entity);
        int i;
        this.player = playerInv.player;
        this.level = this.player.level();
        Vector2i slotOffset = this.getInventorySlotsOffset();
        this.createModeSlots();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18 + slotOffset.x, 84 + i * 18 + slotOffset.y));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInv, i, 8 + i * 18 + slotOffset.x, 142 + slotOffset.y));
        }
    }

    protected abstract void createModeSlots();

    protected boolean isAncientBookStack(ItemStack stack) {
        return stack.is(ItemTagsPM.STATIC_BOOKS) && StaticBookItem.getBookLanguage(stack).map(h -> h.is(BookLanguageTagsPM.ANCIENT)).orElse(false) != false;
    }

    protected Vector2i getInventorySlotsOffset() {
        return new Vector2i(0, 0);
    }

    @Override
    public void itemsChanged(int itemHandlerIndex, IItemHandlerPM pContainer) {
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        ((ScribeTableTileEntity)this.tile).removeInventoryChangeListener(this);
    }

    public void setSynchronizer(ContainerSynchronizer pSynchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            super.setSynchronizer((ContainerSynchronizer)new ContainerSynchronizerLarge(serverPlayer));
        } else {
            super.setSynchronizer(pSynchronizer);
        }
    }
}

