/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.items.misc.RuneItem;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlotProperties;
import com.verdantartifice.primalmagick.common.menus.slots.RunescribingResultSlot;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.tiles.crafting.RunescribingAltarTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public abstract class AbstractRunescribingAltarMenu
extends AbstractTileMenu<RunescribingAltarTileEntity> {
    public static final ResourceLocation RUNE_SLOT_TEXTURE = ResourceUtils.loc("item/empty_rune_slot");
    public static final Component INPUT_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.runescribing_altar.slot.input");
    public static final Component RUNE_SLOT_TOOLTIP = Component.translatable((String)"tooltip.primalmagick.runescribing_altar.slot.rune");
    protected final CraftingContainer altarInv = new TransientCraftingContainer(this, this, 4, 3){

        public int getMaxStackSize() {
            return 1;
        }
    };
    protected final Container resultInv = new SimpleContainer(1);
    protected final Player player;
    protected final Level world;
    protected final Slot runeSlot;

    public AbstractRunescribingAltarMenu(@Nonnull MenuType<?> type, int id, @Nonnull Inventory playerInv, BlockPos tilePos, RunescribingAltarTileEntity altar) {
        super(type, id, RunescribingAltarTileEntity.class, playerInv.player.level(), tilePos, altar);
        int i;
        this.player = playerInv.player;
        this.world = this.player.level();
        this.addSlot(new RunescribingResultSlot(this.player, (Container)this.altarInv, this.resultInv, 0, 138, 35));
        this.addSlot(Services.MENU.makeFilteredSlot(Services.ITEM_HANDLERS.wrap((Container)this.altarInv, null), 0, 19, 35, new FilteredSlotProperties().tooltip(INPUT_SLOT_TOOLTIP)));
        this.runeSlot = this.addRuneSlots();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInv, i, 8 + i * 18, 142));
        }
    }

    protected abstract int getRuneCapacity();

    @Nonnull
    protected abstract Slot addRuneSlots();

    protected static Slot makeRuneSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
        return Services.MENU.makeFilteredSlot(Services.ITEM_HANDLERS.wrap(inventoryIn, null), index, xPosition, yPosition, new FilteredSlotProperties().background(RUNE_SLOT_TEXTURE).tooltip(RUNE_SLOT_TOOLTIP).typeOf((Class<?>)RuneItem.class));
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.clearContainer(playerIn, (Container)this.altarInv);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(slotStack, this.getRuneCapacity() + 2, this.getRuneCapacity() + 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
            } else if (index >= this.getRuneCapacity() + 2 && index < this.getRuneCapacity() + 38 ? (this.runeSlot.mayPlace(slotStack) ? !this.moveItemStackTo(slotStack, 2, this.getRuneCapacity() + 2, false) : !this.moveItemStackTo(slotStack, 1, 2, false)) : !this.moveItemStackTo(slotStack, this.getRuneCapacity() + 2, this.getRuneCapacity() + 38, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return stack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.resultInv && super.canTakeItemForPickAll(stack, slotIn);
    }

    public void slotsChanged(Container inventoryIn) {
        super.slotsChanged(inventoryIn);
        this.slotChangedCraftingGrid();
    }

    protected void slotChangedCraftingGrid() {
        Player player;
        if (!this.world.isClientSide && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)player;
            ItemStack stack = ItemStack.EMPTY;
            ItemStack baseStack = this.altarInv.getItem(0);
            if (!RuneManager.hasRunes(baseStack)) {
                ArrayList<Rune> runes = new ArrayList<Rune>();
                for (int index = 1; index < this.altarInv.getContainerSize(); ++index) {
                    ItemStack inputStack = this.altarInv.getItem(index);
                    if (inputStack == null || !(inputStack.getItem() instanceof RuneItem)) continue;
                    runes.add(((RuneItem)inputStack.getItem()).getRune());
                }
                Map<Holder<Enchantment>, Integer> inputEnch = RuneManager.getRuneEnchantments(this.world.registryAccess(), runes, baseStack, this.player, true);
                if (!inputEnch.isEmpty()) {
                    ItemEnchantments finalEnch = RuneManager.mergeEnchantments(baseStack.getEnchantments(), inputEnch);
                    stack = baseStack.copy();
                    EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)finalEnch);
                    RuneManager.setRunes(stack, runes);
                }
            }
            this.resultInv.setItem(0, stack);
            spe.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, stack));
        }
    }
}

