/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.mana.network;

import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.IManaNetworkNode;
import com.verdantartifice.primalmagick.common.mana.network.IManaSupplier;
import com.verdantartifice.primalmagick.common.mana.network.NetworkGraph;
import com.verdantartifice.primalmagick.common.mana.network.Route;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.util.FunctionUtils;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RouteTable {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected static final Random RANDOM = new Random();
    protected static final int CHECK_INTERVAL = 100;
    protected static final int JITTER_AMOUNT = 20;
    protected final NetworkGraph graph = new NetworkGraph();
    protected int ticksExisted = 0;
    protected int nextCheck = RouteTable.calculateNextCheck(this.ticksExisted);
    private TriFunction<Level, Optional<Source>, BlockPos, Set<Route>> allRoutesCache = FunctionUtils.memoize(this::getAllRoutesInner);

    public void invalidate() {
        this.allRoutesCache = FunctionUtils.memoize(this::getAllRoutesInner);
    }

    public void tick(@NotNull Level level) {
        if (this.ticksExisted >= this.nextCheck) {
            this.cullInactiveNodes(level);
            this.nextCheck = RouteTable.calculateNextCheck(this.ticksExisted);
        }
        ++this.ticksExisted;
    }

    protected static int calculateNextCheck(int currentValue) {
        return currentValue + 100 + RANDOM.nextInt(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        NetworkGraph networkGraph = this.graph;
        synchronized (networkGraph) {
            this.graph.clear();
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull IManaSupplier supplier, @NotNull IManaConsumer consumer) {
        boolean added;
        NetworkGraph networkGraph = this.graph;
        synchronized (networkGraph) {
            added = this.graph.addEdge(consumer.getBlockPos(), supplier.getBlockPos());
        }
        if (added) {
            this.invalidate();
        }
    }

    public Optional<Route> getRoute(@NotNull Level level, @NotNull Optional<Source> sourceOpt, @NotNull IManaSupplier origin, @NotNull IManaConsumer terminus) {
        return ((Set)this.allRoutesCache.apply((Object)level, sourceOpt, (Object)terminus.getBlockPos())).stream().filter(route -> route.getTailPosition().equals((Object)origin.getBlockPos())).findFirst();
    }

    public Set<Route> getAllRoutes(@NotNull Level level, @NotNull Optional<Source> sourceOpt, @NotNull IManaNetworkNode terminus) {
        return (Set)this.allRoutesCache.apply((Object)level, sourceOpt, (Object)terminus.getBlockPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Route> getAllRoutesInner(@NotNull Level level, @NotNull Optional<Source> sourceOpt, @NotNull BlockPos terminusPos) {
        NetworkGraph networkGraph = this.graph;
        synchronized (networkGraph) {
            return this.graph.findAllRoutes(terminusPos, sourceOpt, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cullInactiveNodes(@NotNull Level level) {
        boolean anyRemoved;
        level.getProfiler().push("cullInactiveRoutes");
        NetworkGraph networkGraph = this.graph;
        synchronized (networkGraph) {
            anyRemoved = this.graph.removeIf(pos -> !level.isLoaded(pos) || !(level.getBlockEntity(pos) instanceof IManaNetworkNode));
        }
        if (anyRemoved) {
            this.invalidate();
        }
        level.getProfiler().pop();
    }
}

