/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.mana.network;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.IManaNetworkNode;
import com.verdantartifice.primalmagick.common.mana.network.IManaRelay;
import com.verdantartifice.primalmagick.common.mana.network.IManaSupplier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Route {
    protected final BlockPos headPosition;
    protected final List<BlockPos> relayPositions;
    protected final BlockPos tailPosition;
    protected final Function<Level, List<IManaNetworkNode>> nodeSupplier = Util.memoize(this::getNodesInner);
    protected final Function<Level, List<Hop>> hopSupplier = Util.memoize(this::getHopsInner);
    protected final Function<Level, Boolean> validSupplier = Util.memoize(this::isValidInner);
    protected final Function<Level, Double> distanceSupplier = Util.memoize(this::getDistanceInner);

    protected Route(@NotNull BlockPos headPosition, @NotNull BlockPos tailPosition, @NotNull List<BlockPos> relayPositions) {
        this.headPosition = Objects.requireNonNull(headPosition);
        this.tailPosition = Objects.requireNonNull(tailPosition);
        this.relayPositions = ImmutableList.copyOf(relayPositions.stream().filter(Objects::nonNull).toList());
    }

    public Route(@NotNull List<BlockPos> nodePositions) {
        int size = nodePositions.size();
        if (size < 2) {
            throw new IllegalArgumentException("nodePositions must contain at least 2 nodes");
        }
        this.headPosition = Objects.requireNonNull(nodePositions.getFirst());
        this.tailPosition = Objects.requireNonNull(nodePositions.getLast());
        this.relayPositions = size >= 3 ? ImmutableList.copyOf(nodePositions.subList(1, size - 1)) : ImmutableList.of();
    }

    @NotNull
    public BlockPos getHeadPosition() {
        return this.headPosition;
    }

    @Nullable
    public IManaSupplier getHead(@NotNull Level level) {
        IManaSupplier supplier;
        BlockEntity blockEntity = level.getBlockEntity(this.headPosition);
        return blockEntity instanceof IManaSupplier ? (supplier = (IManaSupplier)blockEntity) : null;
    }

    @NotNull
    public BlockPos getTailPosition() {
        return this.tailPosition;
    }

    @Nullable
    public IManaConsumer getTail(@NotNull Level level) {
        IManaConsumer consumer;
        BlockEntity blockEntity = level.getBlockEntity(this.tailPosition);
        return blockEntity instanceof IManaConsumer ? (consumer = (IManaConsumer)blockEntity) : null;
    }

    @NotNull
    public List<BlockPos> getRelayPositions() {
        return this.relayPositions;
    }

    @Nullable
    public List<IManaRelay> getRelays(@NotNull Level level) {
        List<IManaRelay> retVal = this.relayPositions.stream().map(pos -> {
            IManaRelay relay;
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            return patt0$temp instanceof IManaRelay ? (relay = (IManaRelay)patt0$temp) : null;
        }).toList();
        return retVal.stream().anyMatch(Objects::isNull) ? null : retVal;
    }

    public int getMaxThroughput(@NotNull Level level) {
        List<Hop> hops = this.getHops(level);
        return hops == null ? 0 : hops.stream().mapToInt(Hop::getManaThroughput).min().orElse(0);
    }

    @Nullable
    protected List<IManaNetworkNode> getNodes(@NotNull Level level) {
        return this.nodeSupplier.apply(level);
    }

    @Nullable
    protected List<IManaNetworkNode> getNodesInner(@NotNull Level level) {
        IManaSupplier head = this.getHead(level);
        IManaConsumer tail = this.getTail(level);
        List<IManaRelay> relays = this.getRelays(level);
        if (head != null && tail != null && relays != null) {
            return ImmutableList.builder().add((Object)head).addAll(relays).add((Object)tail).build();
        }
        return null;
    }

    @NotNull
    protected List<BlockPos> getNodePositions() {
        return ImmutableList.builder().add((Object)this.headPosition).addAll(this.relayPositions).add((Object)this.tailPosition).build();
    }

    @Nullable
    public List<Hop> getHops(@NotNull Level level) {
        return this.hopSupplier.apply(level);
    }

    @Nullable
    protected List<Hop> getHopsInner(@NotNull Level level) {
        IManaSupplier head = this.getHead(level);
        IManaConsumer tail = this.getTail(level);
        List<IManaRelay> relays = this.getRelays(level);
        if (head != null && tail != null && relays != null) {
            ArrayList<Hop> retVal = new ArrayList<Hop>();
            IManaSupplier supplier = head;
            for (IManaRelay relay : relays) {
                retVal.add(new Hop(supplier, relay));
                supplier = relay;
            }
            retVal.add(new Hop(supplier, tail));
            return retVal;
        }
        return null;
    }

    public boolean isValid(@NotNull Level level) {
        return this.validSupplier.apply(level);
    }

    protected boolean isValidInner(@NotNull Level level) {
        IManaSupplier supplier;
        IManaConsumer consumer;
        if (this.headPosition.equals((Object)this.tailPosition)) {
            return false;
        }
        IManaSupplier head = this.getHead(level);
        IManaConsumer tail = this.getTail(level);
        List<IManaRelay> relays = this.getRelays(level);
        if (head == null || tail == null || relays == null) {
            return false;
        }
        if (head.isOrigin() && head instanceof IManaConsumer && (consumer = (IManaConsumer)((Object)head)).isTerminus() && tail.isTerminus() && tail instanceof IManaSupplier && (supplier = (IManaSupplier)((Object)tail)).isOrigin()) {
            return false;
        }
        List<IManaNetworkNode> nodes = this.getNodes(level);
        if (nodes == null) {
            return false;
        }
        List<Long> idList = nodes.stream().map(IManaNetworkNode::getNodeId).toList();
        HashSet<Long> deduplicatedIdSet = new HashSet<Long>(idList);
        if (idList.size() > deduplicatedIdSet.size()) {
            return false;
        }
        List<Hop> hops = this.getHops(level);
        return hops != null && hops.stream().allMatch(Hop::inRange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive(Level level) {
        if (!this.isValid(level)) {
            return false;
        }
        if (!level.isLoaded(this.headPosition)) return false;
        if (!level.isLoaded(this.tailPosition)) return false;
        if (!this.relayPositions.stream().allMatch(arg_0 -> ((Level)level).isLoaded(arg_0))) return false;
        return true;
    }

    public double getDistance(@NotNull Level level) {
        return this.distanceSupplier.apply(level);
    }

    protected double getDistanceInner(@NotNull Level level) {
        List<Hop> hops = this.getHops(level);
        return hops == null ? Double.POSITIVE_INFINITY : hops.stream().mapToDouble(Hop::getDistanceSqr).map(Math::sqrt).sum();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Route)) {
            return false;
        }
        Route route = (Route)o;
        return Objects.equals(this.headPosition, route.headPosition) && Objects.equals(this.relayPositions, route.relayPositions) && Objects.equals(this.tailPosition, route.tailPosition);
    }

    public int hashCode() {
        return Objects.hash(this.headPosition, this.relayPositions, this.tailPosition);
    }

    public String toString() {
        return "Route{" + this.getNodePositions().stream().map(pos -> "[" + pos.toShortString() + "]").collect(Collectors.joining("->")) + "}";
    }

    public record Hop(@NotNull IManaSupplier supplier, @NotNull IManaConsumer consumer) {
        public double getDistanceSqr() {
            return this.supplier.getBlockPos().distSqr((Vec3i)this.consumer.getBlockPos());
        }

        public boolean inRange() {
            double distanceSqr = this.getDistanceSqr();
            int supplierRange = this.supplier.getNetworkRange();
            int consumerRange = this.consumer.getNetworkRange();
            return (double)(supplierRange * supplierRange) >= distanceSqr && (double)(consumerRange * consumerRange) >= distanceSqr;
        }

        public int getManaThroughput() {
            return Math.min(this.supplier.getManaThroughput(), this.consumer.getManaThroughput());
        }
    }
}

