/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.mana.network;

import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.IManaNetworkNode;
import com.verdantartifice.primalmagick.common.mana.network.IManaSupplier;
import com.verdantartifice.primalmagick.common.mana.network.Route;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkGraph {
    private final Map<BlockPos, Set<Edge>> edges = new ConcurrentHashMap<BlockPos, Set<Edge>>();

    private boolean addNode(@NotNull BlockPos pos) {
        if (!this.edges.containsKey(pos)) {
            this.edges.put(pos, new HashSet());
            return true;
        }
        return false;
    }

    public boolean addEdge(@NotNull BlockPos from, @NotNull BlockPos to) {
        boolean fromAdded = this.addNode(from);
        boolean toAdded = this.addNode(to);
        boolean edgeAdded = this.edges.get(from).add(new Edge(from, to));
        return fromAdded || toAdded || edgeAdded;
    }

    public boolean removeIf(@NotNull Predicate<BlockPos> predicate) {
        MutableBoolean removed = new MutableBoolean(false);
        this.edges.forEach((key, value) -> {
            if (value.removeIf((? super E edge) -> predicate.test(edge.to()))) {
                removed.setTrue();
            }
        });
        if (this.edges.keySet().removeIf(predicate)) {
            removed.setTrue();
        }
        return removed.getValue();
    }

    public void clear() {
        this.edges.clear();
    }

    public Optional<Route> findRoute(@NotNull BlockPos start, @NotNull BlockPos end, @NotNull Optional<Source> sourceOpt, @NotNull Level level) {
        return NetworkGraph.assemblePath(this.findPreviousEdges(start, sourceOpt, level), start, end).toRoute(level);
    }

    public Set<Route> findAllRoutes(@NotNull BlockPos start, @NotNull Optional<Source> sourceOpt, @NotNull Level level) {
        Map<BlockPos, Edge> previousSteps = this.findPreviousEdges(start, sourceOpt, level);
        return this.edges.keySet().stream().map(endPos -> NetworkGraph.assemblePath(previousSteps, start, endPos).toRoute(level)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static EdgeList assemblePath(@NotNull Map<BlockPos, Edge> previousSteps, @NotNull BlockPos from, @NotNull BlockPos to) {
        EdgeList path = new EdgeList();
        BlockPos current = to;
        if (previousSteps.containsKey(current) || current.equals((Object)from)) {
            while (current != null) {
                Edge edge = previousSteps.get(current);
                if (edge != null) {
                    path.addFirst(edge);
                    current = edge.from();
                    continue;
                }
                current = null;
            }
        }
        return path;
    }

    private Map<BlockPos, Edge> findPreviousEdges(@NotNull BlockPos start, @NotNull Optional<Source> sourceOpt, @NotNull Level level) {
        BlockPos nextVertex;
        if (!this.edges.containsKey(start)) {
            return Map.of();
        }
        HashMap<BlockPos, Double> distances = new HashMap<BlockPos, Double>();
        HashMap<BlockPos, Edge> previousSteps = new HashMap<BlockPos, Edge>();
        HashSet<BlockPos> vertices = new HashSet<BlockPos>();
        this.edges.keySet().forEach(pos -> {
            distances.put((BlockPos)pos, Double.POSITIVE_INFINITY);
            vertices.add((BlockPos)pos);
        });
        distances.put(start, 0.0);
        while (!vertices.isEmpty() && (nextVertex = NetworkGraph.findNextSearchVertex(vertices, distances)) != null) {
            vertices.remove(nextVertex);
            Set neighbors = this.edges.getOrDefault(nextVertex, Set.of());
            double currentDistance = distances.getOrDefault(nextVertex, Double.POSITIVE_INFINITY);
            neighbors.stream().filter(e -> vertices.contains(e.to())).forEach(neighbor -> {
                double alt;
                double d = alt = currentDistance == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : currentDistance + neighbor.getWeight(sourceOpt, level);
                if (alt < distances.getOrDefault(neighbor.to(), Double.POSITIVE_INFINITY)) {
                    distances.put(neighbor.to(), alt);
                    previousSteps.put(neighbor.to(), (Edge)neighbor);
                }
            });
        }
        return previousSteps;
    }

    @Nullable
    private static BlockPos findNextSearchVertex(@NotNull Set<BlockPos> vertices, @NotNull Map<BlockPos, Double> distances) {
        BlockPos retVal = null;
        double minDistance = Double.POSITIVE_INFINITY;
        for (BlockPos pos : vertices) {
            if (retVal != null && !(distances.get(pos) < minDistance)) continue;
            retVal = pos;
            minDistance = distances.get(pos);
        }
        return retVal;
    }

    private record Edge(@NotNull BlockPos from, @NotNull BlockPos to) {
        public double getDistanceSqr() {
            return this.from.distSqr((Vec3i)this.to);
        }

        public boolean inRange(@NotNull Level level) {
            IManaNetworkNode n2;
            IManaNetworkNode toNode;
            IManaNetworkNode n1;
            double distanceSqr = this.getDistanceSqr();
            BlockEntity blockEntity = level.getBlockEntity(this.from);
            IManaNetworkNode fromNode = blockEntity instanceof IManaNetworkNode ? (n1 = (IManaNetworkNode)blockEntity) : null;
            BlockEntity blockEntity2 = level.getBlockEntity(this.to);
            IManaNetworkNode iManaNetworkNode = toNode = blockEntity2 instanceof IManaNetworkNode ? (n2 = (IManaNetworkNode)blockEntity2) : null;
            if (fromNode == null || toNode == null) {
                return false;
            }
            int fromRange = fromNode.getNetworkRange();
            int toRange = toNode.getNetworkRange();
            return (double)(fromRange * fromRange) >= distanceSqr && (double)(toRange * toRange) >= distanceSqr;
        }

        public int getManaThroughput(@NotNull Level level) {
            IManaNetworkNode n2;
            IManaNetworkNode toNode;
            IManaNetworkNode n1;
            BlockEntity blockEntity = level.getBlockEntity(this.from);
            IManaNetworkNode fromNode = blockEntity instanceof IManaNetworkNode ? (n1 = (IManaNetworkNode)blockEntity) : null;
            BlockEntity blockEntity2 = level.getBlockEntity(this.to);
            IManaNetworkNode iManaNetworkNode = toNode = blockEntity2 instanceof IManaNetworkNode ? (n2 = (IManaNetworkNode)blockEntity2) : null;
            if (fromNode == null || toNode == null) {
                return 0;
            }
            return Math.min(fromNode.getManaThroughput(), toNode.getManaThroughput());
        }

        public boolean canRoute(@NotNull Optional<Source> sourceOpt, @NotNull Level level) {
            return sourceOpt.map(source -> {
                IManaSupplier n2;
                IManaSupplier toNode;
                IManaConsumer n1;
                BlockEntity patt0$temp = level.getBlockEntity(this.from);
                IManaConsumer fromNode = patt0$temp instanceof IManaConsumer ? (n1 = (IManaConsumer)patt0$temp) : null;
                BlockEntity patt0$temp2 = level.getBlockEntity(this.to);
                IManaSupplier iManaSupplier = toNode = patt0$temp2 instanceof IManaSupplier ? (n2 = (IManaSupplier)patt0$temp2) : null;
                if (fromNode == null || toNode == null) {
                    return false;
                }
                return fromNode.canConsume((Source)source) && toNode.canSupply((Source)source);
            }).orElse(true);
        }

        public double getWeight(@NotNull Optional<Source> sourceOpt, @NotNull Level level) {
            if (!this.inRange(level) || !this.canRoute(sourceOpt, level)) {
                return Double.POSITIVE_INFINITY;
            }
            int throughput = this.getManaThroughput(level);
            return throughput == 0 ? Double.POSITIVE_INFINITY : this.getDistanceSqr() * (1.0 / (double)(throughput * throughput));
        }
    }

    private static class EdgeList
    extends LinkedList<Edge> {
        private EdgeList() {
        }

        public Optional<Route> toRoute(@NotNull Level level) {
            if (this.isEmpty()) {
                return Optional.empty();
            }
            LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
            BlockPos lastTo = ((Edge)this.getFirst()).from();
            positions.add(lastTo);
            for (Edge edge : this) {
                if (!lastTo.equals((Object)edge.from())) {
                    return Optional.empty();
                }
                lastTo = edge.to();
                positions.add(lastTo);
            }
            Collections.reverse(positions);
            Route retVal = new Route(positions);
            return retVal.isValid(level) ? Optional.of(retVal) : Optional.empty();
        }
    }
}

