/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.mana.network;

import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.IManaNetworkNode;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public interface IManaSupplier
extends IManaNetworkNode {
    default public boolean isOrigin() {
        return true;
    }

    public boolean canSupply(@NotNull Source var1);

    public int extractMana(@NotNull Source var1, int var2, boolean var3);

    @Override
    default public void loadManaNetwork(@NotNull Level level) {
        if (!Services.CONFIG.enableManaNetworking()) {
            LogUtils.getLogger().warn("Mana networking not enabled; skipping default supplier bootstrap");
            return;
        }
        level.getProfiler().push("loadManaNetwork");
        level.getProfiler().push("defaultManaSupplier");
        int range = this.getNetworkRange();
        int rangeSqr = range * range;
        level.getProfiler().push("findNodes");
        List<IManaConsumer> consumers = BlockPos.betweenClosedStream((AABB)new AABB(this.getBlockPos()).inflate((double)range)).filter(pos -> pos.distSqr((Vec3i)this.getBlockPos()) <= (double)rangeSqr).map(pos -> {
            IManaConsumer consumer;
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            return patt0$temp instanceof IManaConsumer ? (consumer = (IManaConsumer)patt0$temp) : null;
        }).filter(Objects::nonNull).toList();
        level.getProfiler().popPush("createDirectConsumerEdges");
        consumers.forEach(consumer -> this.getRouteTable().add(this, (IManaConsumer)consumer));
        level.getProfiler().pop();
        level.getProfiler().pop();
        level.getProfiler().pop();
    }
}

