/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.mana.network;

import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.mana.network.IManaConsumer;
import com.verdantartifice.primalmagick.common.mana.network.IManaNetworkNode;
import com.verdantartifice.primalmagick.common.mana.network.IManaSupplier;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public interface IManaRelay
extends IManaSupplier,
IManaConsumer {
    @Override
    default public boolean isTerminus() {
        return false;
    }

    @Override
    default public boolean isOrigin() {
        return false;
    }

    @Override
    default public int extractMana(@NotNull Source source, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    default public int receiveMana(@NotNull Source source, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    default public boolean canSupply(@NotNull Source source) {
        return this.canRelay(source);
    }

    @Override
    default public boolean canConsume(@NotNull Source source) {
        return this.canRelay(source);
    }

    public boolean canRelay(Source var1);

    @Override
    default public void loadManaNetwork(@NotNull Level level) {
        if (!Services.CONFIG.enableManaNetworking()) {
            LogUtils.getLogger().warn("Mana networking not enabled; skipping default relay bootstrap");
            return;
        }
        level.getProfiler().push("loadManaNetwork");
        level.getProfiler().push("defaultManaRelay");
        int range = this.getNetworkRange();
        int rangeSqr = range * range;
        level.getProfiler().push("findNodes");
        List<IManaNetworkNode> nodes = BlockPos.betweenClosedStream((AABB)new AABB(this.getBlockPos()).inflate((double)range)).filter(pos -> !this.getBlockPos().equals(pos) && pos.distSqr((Vec3i)this.getBlockPos()) <= (double)rangeSqr).map(pos -> {
            IManaNetworkNode node;
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            return patt0$temp instanceof IManaNetworkNode ? (node = (IManaNetworkNode)patt0$temp) : null;
        }).filter(Objects::nonNull).toList();
        level.getProfiler().popPush("createDirectSupplierEdges");
        nodes.stream().map(node -> {
            IManaSupplier supplier;
            return node instanceof IManaSupplier ? (supplier = (IManaSupplier)node) : null;
        }).filter(Objects::nonNull).forEach(supplier -> this.getRouteTable().add((IManaSupplier)supplier, this));
        level.getProfiler().popPush("createDirectConsumerEdges");
        nodes.stream().map(node -> {
            IManaConsumer consumer;
            return node instanceof IManaConsumer ? (consumer = (IManaConsumer)node) : null;
        }).filter(Objects::nonNull).forEach(consumer -> this.getRouteTable().add(this, (IManaConsumer)consumer));
        level.getProfiler().pop();
        level.getProfiler().pop();
        level.getProfiler().pop();
    }
}

