/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.mana.network;

import com.mojang.logging.LogUtils;
import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.mana.network.IManaNetworkNode;
import com.verdantartifice.primalmagick.common.mana.network.IManaSupplier;
import com.verdantartifice.primalmagick.common.mana.network.Route;
import com.verdantartifice.primalmagick.common.mana.network.RouteTable;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.ManaSparklePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IManaConsumer
extends IManaNetworkNode {
    default public boolean isTerminus() {
        return true;
    }

    public boolean canConsume(@NotNull Source var1);

    public int receiveMana(@NotNull Source var1, int var2, boolean var3);

    default public int doSiphon(@Nullable Player owner, @NotNull Level level, @NotNull Source source, int maxTransferCentimana) {
        level.getProfiler().push("doSiphon");
        level.getProfiler().push("defaultManaConsumer");
        int totalSiphoned = 0;
        int remainingTransfer = maxTransferCentimana;
        RouteTable routeTable = this.getRouteTable();
        HashSet<Route.Hop> particleHops = new HashSet<Route.Hop>();
        level.getProfiler().push("findBestRoutes");
        List<Route> routes = routeTable.getAllRoutes(level, Optional.of(source), this).stream().filter(route -> route.isActive(level)).sorted(Comparator.comparing(route -> route.getMaxThroughput(level)).reversed().thenComparing(Route::hashCode)).toList();
        level.getProfiler().popPush("doTransfer");
        Iterator<Route> routeIterator = routes.iterator();
        while (remainingTransfer > 0 && routeIterator.hasNext()) {
            Route route2 = routeIterator.next();
            IManaSupplier head = route2.getHead(level);
            IManaConsumer tail = route2.getTail(level);
            if (head == null || tail == null) continue;
            int toExtract = Math.min(remainingTransfer, route2.getMaxThroughput(level));
            int actualExtracted = head.extractMana(source, toExtract, false);
            int actualReceived = tail.receiveMana(source, actualExtracted, false);
            totalSiphoned += actualReceived;
            remainingTransfer -= actualReceived;
            if (actualReceived <= 0) continue;
            List<Route.Hop> hops = route2.getHops(level);
            if (hops != null && !hops.isEmpty()) {
                particleHops.addAll(hops);
            }
            if (!(owner instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            CriteriaTriggersPM.MANA_NETWORK_ROUTE_LENGTH.get().trigger(serverPlayer, route2.getDistance(level));
        }
        level.getProfiler().popPush("showParticles");
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            particleHops.forEach(hop -> PacketHandler.sendToAllAround(new ManaSparklePacket((Position)hop.supplier().getBlockPos().getCenter(), (Position)hop.consumer().getBlockPos().getCenter(), 20, source), serverLevel, hop.supplier().getBlockPos(), 32.0));
        }
        level.getProfiler().pop();
        level.getProfiler().pop();
        level.getProfiler().pop();
        return totalSiphoned;
    }

    @Override
    default public void loadManaNetwork(@NotNull Level level) {
        if (!Services.CONFIG.enableManaNetworking()) {
            LogUtils.getLogger().warn("Mana networking not enabled; skipping default consumer bootstrap");
            return;
        }
        level.getProfiler().push("loadManaNetwork");
        level.getProfiler().push("defaultManaConsumer");
        int range = this.getNetworkRange();
        int rangeSqr = range * range;
        level.getProfiler().push("findNodes");
        List<IManaSupplier> suppliers = BlockPos.betweenClosedStream((AABB)new AABB(this.getBlockPos()).inflate((double)range)).filter(pos -> pos.distSqr((Vec3i)this.getBlockPos()) <= (double)rangeSqr).map(pos -> {
            IManaSupplier supplier;
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            return patt0$temp instanceof IManaSupplier ? (supplier = (IManaSupplier)patt0$temp) : null;
        }).filter(Objects::nonNull).toList();
        level.getProfiler().popPush("createDirectSupplierEdges");
        suppliers.forEach(supplier -> this.getRouteTable().add((IManaSupplier)supplier, this));
        level.getProfiler().pop();
        level.getProfiler().pop();
        level.getProfiler().pop();
    }
}

