/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.loot.LootModifiers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class RelicFragmentsModifier
extends LootModifier {
    public static final MapCodec<RelicFragmentsModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> RelicFragmentsModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("targetTag").forGetter(m -> m.targetTag), (App)Codec.INT.fieldOf("minCount").forGetter(m -> m.minCount), (App)Codec.INT.fieldOf("maxCount").forGetter(m -> m.maxCount))).apply((Applicative)inst, RelicFragmentsModifier::new));
    protected final TagKey<EntityType<?>> targetTag;
    protected final int minCount;
    protected final int maxCount;

    public RelicFragmentsModifier(LootItemCondition[] conditionsIn, TagKey<EntityType<?>> targetTag, int minCount, int maxCount) {
        super(conditionsIn);
        this.targetTag = targetTag;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return LootModifiers.relicFragments(generatedLoot, context, this.targetTag, this.minCount, this.maxCount);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

