/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.loot.LootModifiers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class GuillotineModifier
extends LootModifier {
    public static final MapCodec<GuillotineModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> GuillotineModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("targetTag").forGetter(m -> m.targetTag)).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, GuillotineModifier::new));
    protected final TagKey<EntityType<?>> targetTag;
    protected final Item item;
    protected final float chance;

    public GuillotineModifier(LootItemCondition[] conditionsIn, TagKey<EntityType<?>> targetTag, Item item, float chance) {
        super(conditionsIn);
        this.targetTag = targetTag;
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return LootModifiers.guillotine(generatedLoot, context, this.targetTag, this.item, this.chance);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

