/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.loot.LootModifiers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class BonusNuggetModifier
extends LootModifier {
    public static final MapCodec<BonusNuggetModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> BonusNuggetModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.unboundedMap((Codec)TagKey.codec((ResourceKey)Registries.BLOCK), (Codec)TagKey.codec((ResourceKey)Registries.ITEM)).fieldOf("nuggetMap").forGetter(m -> m.nuggetMap), (App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance)))).apply((Applicative)inst, BonusNuggetModifier::new));
    protected final float chance;
    protected final Map<TagKey<Block>, TagKey<Item>> nuggetMap;

    public BonusNuggetModifier(LootItemCondition[] conditions, Map<TagKey<Block>, TagKey<Item>> nuggetMap, float chance) {
        super(conditions);
        this.nuggetMap = nuggetMap;
        this.chance = chance;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return LootModifiers.bonusNugget(generatedLoot, context, this.chance, this.nuggetMap);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

