/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot;

import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class LootTablesPM {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = new HashSet<ResourceKey<LootTable>>();
    private static final Set<ResourceKey<LootTable>> SUBSET_TREEFOLK_BARTERING = new HashSet<ResourceKey<LootTable>>();
    private static final Set<ResourceKey<LootTable>> SUBSET_THEORYCRAFTING = new HashSet<ResourceKey<LootTable>>();
    private static final Set<ResourceKey<LootTable>> SUBSET_LIBRARY = new HashSet<ResourceKey<LootTable>>();
    public static final ResourceKey<LootTable> TREEFOLK_BARTERING = LootTablesPM.registerTreefolk("gameplay/treefolk_bartering");
    public static final ResourceKey<LootTable> TREEFOLK_BARTERING_FOOD = LootTablesPM.registerTreefolk("gameplay/treefolk_bartering/food");
    public static final ResourceKey<LootTable> TREEFOLK_BARTERING_SAPLINGS = LootTablesPM.registerTreefolk("gameplay/treefolk_bartering/saplings");
    public static final ResourceKey<LootTable> TREEFOLK_BARTERING_SEEDS = LootTablesPM.registerTreefolk("gameplay/treefolk_bartering/seeds");
    public static final ResourceKey<LootTable> TREEFOLK_BARTERING_JUNK = LootTablesPM.registerTreefolk("gameplay/treefolk_bartering/junk");
    public static final ResourceKey<LootTable> TREEFOLK_BARTERING_TREASURE = LootTablesPM.registerTreefolk("gameplay/treefolk_bartering/treasure");
    public static final ResourceKey<LootTable> THEORYCRAFTING_TRADE = LootTablesPM.registerTheorycraft("gameplay/theorycrafting/trade");
    public static final ResourceKey<LootTable> THEORYCRAFTING_PROSPEROUS_TRADE = LootTablesPM.registerTheorycraft("gameplay/theorycrafting/prosperous_trade");
    public static final ResourceKey<LootTable> THEORYCRAFTING_RICH_TRADE = LootTablesPM.registerTheorycraft("gameplay/theorycrafting/rich_trade");
    public static final ResourceKey<LootTable> LIBRARY_EARTH = LootTablesPM.registerLibrary("gameplay/library/earth");
    public static final ResourceKey<LootTable> LIBRARY_SEA = LootTablesPM.registerLibrary("gameplay/library/sea");
    public static final ResourceKey<LootTable> LIBRARY_SKY = LootTablesPM.registerLibrary("gameplay/library/sky");
    public static final ResourceKey<LootTable> LIBRARY_SUN = LootTablesPM.registerLibrary("gameplay/library/sun");
    public static final ResourceKey<LootTable> LIBRARY_MOON = LootTablesPM.registerLibrary("gameplay/library/moon");
    public static final ResourceKey<LootTable> LIBRARY_FORBIDDEN = LootTablesPM.registerLibrary("gameplay/library/forbidden");
    public static final ResourceKey<LootTable> LIBRARY_WELCOME = LootTablesPM.registerLibrary("gameplay/library/welcome");
    public static final ResourceKey<LootTable> LIBRARY_WARNING = LootTablesPM.registerLibrary("gameplay/library/warning");
    public static final ResourceKey<LootTable> LIBRARY_HIDDEN = LootTablesPM.registerLibrary("gameplay/library/hidden");
    public static final ResourceKey<LootTable> LIBRARY_ARCHAEOLOGY = LootTablesPM.registerLibrary("gameplay/library/archaeology");
    public static final ResourceKey<LootTable> LIBRARY_CULTURE_EARTH = LootTablesPM.registerLibrary("gameplay/library/culture/earth");
    public static final ResourceKey<LootTable> LIBRARY_CULTURE_SEA = LootTablesPM.registerLibrary("gameplay/library/culture/sea");
    public static final ResourceKey<LootTable> LIBRARY_CULTURE_SKY = LootTablesPM.registerLibrary("gameplay/library/culture/sky");
    public static final ResourceKey<LootTable> LIBRARY_CULTURE_SUN = LootTablesPM.registerLibrary("gameplay/library/culture/sun");
    public static final ResourceKey<LootTable> LIBRARY_CULTURE_MOON = LootTablesPM.registerLibrary("gameplay/library/culture/moon");
    public static final ResourceKey<LootTable> LIBRARY_CULTURE_TRADE = LootTablesPM.registerLibrary("gameplay/library/culture/trade");
    public static final ResourceKey<LootTable> LIBRARY_CULTURE_FORBIDDEN = LootTablesPM.registerLibrary("gameplay/library/culture/forbidden");
    public static final ResourceKey<LootTable> LIBRARY_CULTURE_HALLOWED = LootTablesPM.registerLibrary("gameplay/library/culture/hallowed");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_COMMON = LootTablesPM.registerLibrary("gameplay/library/catalog/common");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_UNCOMMON = LootTablesPM.registerLibrary("gameplay/library/catalog/uncommon");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_RARE = LootTablesPM.registerLibrary("gameplay/library/catalog/rare");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_EPIC_EARTH = LootTablesPM.registerLibrary("gameplay/library/catalog/epic/earth");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_EPIC_SEA = LootTablesPM.registerLibrary("gameplay/library/catalog/epic/sea");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_EPIC_SKY = LootTablesPM.registerLibrary("gameplay/library/catalog/epic/sky");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_EPIC_SUN = LootTablesPM.registerLibrary("gameplay/library/catalog/epic/sun");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_EPIC_MOON = LootTablesPM.registerLibrary("gameplay/library/catalog/epic/moon");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_EPIC_TRADE = LootTablesPM.registerLibrary("gameplay/library/catalog/epic/trade");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_EPIC_FORBIDDEN = LootTablesPM.registerLibrary("gameplay/library/catalog/epic/forbidden");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_EPIC_HALLOWED = LootTablesPM.registerLibrary("gameplay/library/catalog/epic/hallowed");
    public static final ResourceKey<LootTable> LIBRARY_CATALOG_TREASURE = LootTablesPM.registerLibrary("gameplay/library/catalog/treasure");

    private static ResourceKey<LootTable> registerTreefolk(String id) {
        return LootTablesPM.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceUtils.loc(id)), SUBSET_TREEFOLK_BARTERING);
    }

    private static ResourceKey<LootTable> registerTheorycraft(String id) {
        return LootTablesPM.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceUtils.loc(id)), SUBSET_THEORYCRAFTING);
    }

    private static ResourceKey<LootTable> registerLibrary(String id) {
        return LootTablesPM.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceUtils.loc(id)), SUBSET_LIBRARY);
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> id, Set<ResourceKey<LootTable>> tableSubset) {
        if (LOCATIONS.add(id) && tableSubset.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is already a registered built-in loot table");
    }

    public static Set<ResourceKey<LootTable>> all() {
        return Collections.unmodifiableSet(LOCATIONS);
    }

    public static Set<ResourceKey<LootTable>> treefolkBartering() {
        return Collections.unmodifiableSet(SUBSET_TREEFOLK_BARTERING);
    }

    public static Set<ResourceKey<LootTable>> theorycrafting() {
        return Collections.unmodifiableSet(SUBSET_THEORYCRAFTING);
    }

    public static Set<ResourceKey<LootTable>> library() {
        return Collections.unmodifiableSet(SUBSET_LIBRARY);
    }
}

