/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot;

import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import com.verdantartifice.primalmagick.platform.Services;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootModifiers {
    public static ObjectArrayList<ItemStack> addItem(ObjectArrayList<ItemStack> generatedLoot, LootContext context, Item item, UniformInt rolls) {
        IntStream.range(0, rolls.sample(context.getRandom())).forEach($ -> generatedLoot.add((Object)new ItemStack((ItemLike)item)));
        return generatedLoot;
    }

    public static ObjectArrayList<ItemStack> bloodNotes(ObjectArrayList<ItemStack> generatedLoot, LootContext context, TagKey<EntityType<?>> targetTag) {
        Entity targetEntity = (Entity)context.getParam(LootContextParams.THIS_ENTITY);
        if (targetEntity.getType().is(targetTag)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)ItemsPM.BLOOD_NOTES.get()));
        }
        return generatedLoot;
    }

    public static ObjectArrayList<ItemStack> bloodyFlesh(ObjectArrayList<ItemStack> generatedLoot, LootContext context, TagKey<EntityType<?>> targetTag) {
        Entity targetEntity = (Entity)context.getParam(LootContextParams.THIS_ENTITY);
        if (targetEntity.getType().is(targetTag)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)ItemsPM.BLOODY_FLESH.get()));
        }
        return generatedLoot;
    }

    public static ObjectArrayList<ItemStack> bonusNugget(ObjectArrayList<ItemStack> generatedLoot, LootContext context, float chance, Map<TagKey<Block>, TagKey<Item>> nuggetMap) {
        int enchantmentLevel;
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        ItemStack tool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        int n = enchantmentLevel = tool == null ? 0 : tool.getEnchantments().getLevel((Holder)context.getResolver().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentsPM.LUCKY_STRIKE));
        if (state != null && enchantmentLevel > 0) {
            nuggetMap.forEach((blockTag, itemTag) -> {
                if (state.is(blockTag) && Services.ITEMS_REGISTRY.tagExists(itemTag)) {
                    Optional nuggetOpt = Services.ITEMS_REGISTRY.getTag(itemTag).stream().findFirst();
                    nuggetOpt.ifPresent(nugget -> {
                        int nuggetCount = IntStream.range(0, enchantmentLevel).map(i -> context.getRandom().nextFloat() < chance ? 1 : 0).sum();
                        generatedLoot.add((Object)new ItemStack((ItemLike)nugget, nuggetCount));
                    });
                }
            });
        }
        return generatedLoot;
    }

    public static ObjectArrayList<ItemStack> bountyFarming(ObjectArrayList<ItemStack> generatedLoot, LootContext context, float chance) {
        LootTable table = context.getLevel().getServer().reloadableRegistries().getLootTable(((BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE)).getBlock().getLootTable());
        return LootModifiers.bountyInner(generatedLoot, context, chance, table);
    }

    public static ObjectArrayList<ItemStack> bountyFishing(ObjectArrayList<ItemStack> generatedLoot, LootContext context, float chance) {
        LootTable table = context.getLevel().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
        return LootModifiers.bountyInner(generatedLoot, context, chance, table);
    }

    private static ObjectArrayList<ItemStack> bountyInner(ObjectArrayList<ItemStack> generatedLoot, LootContext context, float chance, LootTable table) {
        ItemStack tool = context.hasParam(LootContextParams.TOOL) ? (ItemStack)context.getParam(LootContextParams.TOOL) : ItemStack.EMPTY;
        int enchantmentLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)context.getResolver().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentsPM.BOUNTY), (ItemStack)tool);
        for (int index = 0; index < enchantmentLevel; ++index) {
            if (!(context.getRandom().nextFloat() < chance)) continue;
            ArrayList<ItemStack> bonusList = new ArrayList<ItemStack>();
            table.getRandomItemsRaw(context, bonusList::add);
            generatedLoot = (ObjectArrayList)ItemUtils.mergeItemStackLists(generatedLoot, bonusList).stream().collect(ObjectArrayList.toList());
        }
        return generatedLoot;
    }

    public static ObjectArrayList<ItemStack> essenceThief(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Object object = context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (object instanceof LivingEntity) {
            SourceList affinities;
            LivingEntity victim = (LivingEntity)object;
            int enchantLevel = LootModifiers.getEnchantLevel(context, EnchantmentsPM.ESSENCE_THIEF);
            if (enchantLevel > 0 && (affinities = AffinityManager.getInstance().getAffinityValuesAsync(victim.getType(), victim.level().registryAccess()).join()) != null && !affinities.isEmpty()) {
                WeightedRandomBag<Source> bag = new WeightedRandomBag<Source>();
                for (Source source : affinities.getSources()) {
                    int amount = affinities.getAmount(source);
                    if (amount <= 0) continue;
                    bag.add(source, amount);
                }
                EssenceType type = switch (enchantLevel) {
                    case 1 -> EssenceType.DUST;
                    case 2 -> EssenceType.SHARD;
                    case 3 -> EssenceType.CRYSTAL;
                    default -> EssenceType.CLUSTER;
                };
                generatedLoot.add((Object)EssenceItem.getEssence(type, (Source)bag.getRandom(context.getRandom())));
            }
        }
        return generatedLoot;
    }

    private static int getEnchantLevel(LootContext context, ResourceKey<Enchantment> key) {
        Object object = context.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        if (object instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)object;
            Holder.Reference ench = context.getResolver().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(key);
            return ((Enchantment)ench.value()).getSlotItems(killer).values().stream().mapToInt(arg_0 -> LootModifiers.lambda$getEnchantLevel$4((Holder)ench, arg_0)).max().orElse(0);
        }
        return 0;
    }

    public static ObjectArrayList<ItemStack> guillotine(ObjectArrayList<ItemStack> generatedLoot, LootContext context, TagKey<EntityType<?>> targetTag, Item item, float chance) {
        Object object = context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (object instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)object;
            if (generatedLoot.stream().noneMatch(stack -> stack.is(item))) {
                int enchantLevel = LootModifiers.getEnchantLevel(context, EnchantmentsPM.GUILLOTINE);
                if (livingTarget.getType().is(targetTag) && enchantLevel > 0 && context.getRandom().nextFloat() < chance * (float)enchantLevel) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)item));
                }
            }
        }
        return generatedLoot;
    }

    public static ObjectArrayList<ItemStack> relicFragments(ObjectArrayList<ItemStack> generatedLoot, LootContext context, TagKey<EntityType<?>> targetTag, int minCount, int maxCount) {
        Entity targetEntity = (Entity)context.getParam(LootContextParams.THIS_ENTITY);
        int count = context.getRandom().nextInt(maxCount - minCount + 1) + minCount;
        if (targetEntity.getType().is(targetTag) && count > 0) {
            generatedLoot.add((Object)new ItemStack((ItemLike)ItemsPM.MYSTICAL_RELIC_FRAGMENT.get(), count));
        }
        return generatedLoot;
    }

    public static ObjectArrayList<ItemStack> replaceItem(ObjectArrayList<ItemStack> generatedLoot, LootContext context, Item item) {
        generatedLoot.clear();
        generatedLoot.add((Object)new ItemStack((ItemLike)item));
        return generatedLoot;
    }

    private static /* synthetic */ int lambda$getEnchantLevel$4(Holder ench, ItemStack stack) {
        return stack.getEnchantments().getLevel(ench);
    }
}

